package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.PageSizeReq;
import com.baijiayun.openapi.sdk.dto.RoomPageReq;
import com.baijiayun.openapi.sdk.dto.doubleteacher.*;

/**
 * Auto generate interface of DoubleTeacherApi.
 */
@BjyClient
public interface DoubleTeacherApi {

    /**
     * API-1: 添加校区
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_DOUBLE_TEACHER_ADD_ZONE)
    BjyResult<Void> addZone(BjyPartnerInfo partnerInfo, AddZoneReq req);

    /**
     * API-2: 获取校区列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_DOUBLE_TEACHER_LIST_ZONE)
    BjyResult<Void> listZone(BjyPartnerInfo partnerInfo, PageSizeReq req);

    /**
     * API-3: 更新校区
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_DOUBLE_TEACHER_UPDATE_ZONE)
    BjyResult<Void> updateZone(BjyPartnerInfo partnerInfo, UpdateZoneReq req);

    /**
     * API-4: 删除校区
     * @param partnerInfo 百家云合作者参数
     * @param zoneId [必填] zone_id 校区ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_DOUBLE_TEACHER_DELETE_ZONE)
    BjyResult<Void> deleteZone(BjyPartnerInfo partnerInfo, @RequestParam("zone_id") Integer zoneId);

    /**
     * API-5: 获取设备列表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_5_DOUBLE_TEACHER_LIST_DEVICE)
    BjyResult<Void> listDevice(BjyPartnerInfo partnerInfo, ListDeviceReq req);

    /**
     * API-6: 更新双师设备信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_6_DOUBLE_TEACHER_UPDATE_DEVICE_INFO)
    BjyResult<Void> updateDeviceInfo(BjyPartnerInfo partnerInfo, UpdateDeviceInfoReq req);

    /**
     * API-7: 给课程绑定设备
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_7_DOUBLE_TEACHER_BIND_DEVICE)
    BjyResult<Void> bindDevice(BjyPartnerInfo partnerInfo, BindDeviceReq req);

    /**
     * API-8: 批量给课程绑定听课设备
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_8_DOUBLE_TEACHER_BIND_STUDENT_DEVICE_BATCH)
    BjyResult<Void> bindStudentDeviceBatch(BjyPartnerInfo partnerInfo, BindStudentDeviceBatchReq req);

    /**
     * API-9: 设备绑定多个课程
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_9_DOUBLE_TEACHER_BIND_ROOM_BATCH)
    BjyResult<Void> bindRoomBatch(BjyPartnerInfo partnerInfo, BindRoomBatchReq req);

    /**
     * API-10: 解除课程与设备关联
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_DOUBLE_TEACHER_UNBIND_DEVICE)
    BjyResult<Void> unbindDevice(BjyPartnerInfo partnerInfo, UnbindDeviceReq req);

    /**
     * API-11: 批量解除课程与设备关联
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_DOUBLE_TEACHER_UNBIND_DEVICE_BATCH)
    BjyResult<Void> unbindDeviceBatch(BjyPartnerInfo partnerInfo, UnbindDeviceBatchReq req);

    /**
     * API-12: 更新课程绑定的全部学生端
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_DOUBLE_TEACHER_SET_ALL_STUDENT_DEVICE)
    BjyResult<Void> setAllStudentDevice(BjyPartnerInfo partnerInfo, SetAllStudentDeviceReq req);

    /**
     * API-13: 获取直播房间关联的设备信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_DOUBLE_TEACHER_GET_ROOM_DEVICE_INFO)
    BjyResult<Void> getRoomDeviceInfo(BjyPartnerInfo partnerInfo, RoomPageReq req);

    /**
     * API-14: 获取设备最近一次激活记录
     * @param partnerInfo 百家云合作者参数
     * @param deviceId 设备号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_DOUBLE_TEACHER_GET_RECENT_ACTIVATE_RECORD)
    BjyResult<Void> getRecentActivateRecord(BjyPartnerInfo partnerInfo, @RequestParam("device_id") Integer deviceId);

    /**
     * API-15: 获取加盟商信息
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_15_DOUBLE_TEACHER_GET_AFFILIATE_PARTNER)
    BjyResult<Void> getAffiliatePartner(BjyPartnerInfo partnerInfo, PageSizeReq req);

    /**
     * 添加单个课节
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_DOUBLE_TEACHER_ADD_SCHEDULE)
    BjyResult<Void> addSchedule(BjyPartnerInfo partnerInfo, AddScheduleReq req);

    /**
     * 设置教室排课信息表
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_DOUBLE_TEACHER_SET_ROOM_SCHEDULES)
    BjyResult<Void> setRoomSchedules(BjyPartnerInfo partnerInfo, SetRoomSchedulesReq req);

    /**
     * API-15: 添加录播课程
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_15_DOUBLE_TEACHER_CREATE_RECORD_COURSE)
    BjyResult<Void> createRecordCourse(BjyPartnerInfo partnerInfo, CreateRecordCourseReq req);

    /**
     * API-16: 录播课程添加视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_16_DOUBLE_TEACHER_ADD_COURSE_VIDEO)
    BjyResult<Void> addCourseVideo(BjyPartnerInfo partnerInfo, AddCourseVideoReq req);

    /**
     * API-17: 录播课程删除视频
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_17_DOUBLE_TEACHER_DELETE_COURSE_VIDEO)
    BjyResult<Void> deleteCourseVideo(BjyPartnerInfo partnerInfo, DeleteCourseVideoReq req);

    /**
     * API-18: 设备绑定录播课程
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_18_DOUBLE_TEACHER_BIND_DEVICE_COURSE)
    BjyResult<Void> bindDeviceCourse(BjyPartnerInfo partnerInfo, BindDeviceCourseReq req);

    /**
     * API-19: 设备解绑录播课程
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_19_DOUBLE_TEACHER_UNBIND_DEVICE_COURSE)
    BjyResult<Void> unbindDeviceCourse(BjyPartnerInfo partnerInfo, UnbindDeviceCourseReq req);
}