package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.IdResp;
import com.baijiayun.openapi.sdk.dto.doc.*;

/**
 * Auto generate interface of DocApi.
 */
@BjyClient
public interface DocApi {

    /**
     * API 10 : 直播课件文档上传
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_10_DOC_UPLOAD_DOC)
    BjyResult<UploadDocResp> uploadDoc(BjyPartnerInfo partnerInfo, UploadDocReq req);

    /**
     * API 11 : 关联文档到教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_11_DOC_BIND_DOC)
    BjyResult<BindDocResp> bindDoc(BjyPartnerInfo partnerInfo, BindDocReq req);

    /**
     * API 12 : 获取指定教室内已上传的文档列表
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_12_DOC_LIST_DOC)
    BjyResult<ListDocResp> listDoc(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 13 : 获取账号下上传的所有文档
     * @param partnerInfo 百家云合作者参数
     * @param type [必填] type 可选值 all:所有文档 room:教室里上传的文件 api:从api接口上传的文档 management:从后台文件管理上传的文档
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_13_DOC_LIST_ALL_DOC)
    BjyResult<Void> listAllDoc(BjyPartnerInfo partnerInfo, String type);

    /**
     * API 14 : 移除教室内文档
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_14_DOC_REMOVE_DOC)
    BjyResult<RemoveDocResp> removeDoc(BjyPartnerInfo partnerInfo, RemoveDocReq req);

    /**
     * API 61 : 直播音视频课件上传
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_61_DOC_UPLOAD_VIDEO_DOC)
    BjyResult<Void> uploadVideoDoc(BjyPartnerInfo partnerInfo, UploadVideoDocReq req);

    /**
     * API 68 : 关联多个文档到教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_68_DOC_BIND_ROOM_MULTI)
    BjyResult<Void> bindRoomMulti(BjyPartnerInfo partnerInfo, BindRoomMultiReq req);

    /**
     * API 75 : 获取教室内音视频课件
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 房间号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_75_DOC_GET_ROOM_VIDEO_LIST)
    BjyResult<GetRoomVideoListResp> getRoomVideoList(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 76 : 创建文件夹
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_76_DOC_CREATE_DIRECTORY)
    BjyResult<Void> createDirectory(BjyPartnerInfo partnerInfo, CreateDirectoryReq req);

    /**
     * API 106 : 通过url上传文件
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_106_DOC_UPLOAD_WITH_URL)
    BjyResult<Void> uploadWithUrl(BjyPartnerInfo partnerInfo, UploadWithUrlReq req);

    /**
     * API 107 : 通过文件夹关联课件到教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_107_DOC_BIND_ROOM_DOC_WITH_FINDERS)
    BjyResult<Void> bindRoomDocWithFinders(BjyPartnerInfo partnerInfo, BindRoomDocWithFindersReq req);

    /**
     * API 108 : 删除指定文件夹及文件夹中的文件
     * @param partnerInfo 百家云合作者参数
     * @param finderId [必填] finder_id 要删除的文件夹id
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_108_DOC_DELETE_DOC_FINDER)
    BjyResult<Void> deleteDocFinder(BjyPartnerInfo partnerInfo, @RequestParam("finder_id") Integer finderId);

    /**
     * API 35 : 使用url上传h5课件
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_35_DOC_UPLOAD_H5_BY_URL)
    BjyResult<Void> uploadH5ByUrl(BjyPartnerInfo partnerInfo, UploadH5ByUrlReq req);

    /**
     * API 38 : 关联文档到多个教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_38_DOC_BIND_DOC_MULTI)
    BjyResult<Void> bindDocMulti(BjyPartnerInfo partnerInfo, BindDocMultiReq req);

    /**
     * API 45 : 小班课课件关联增加课件预览接口
     * @param partnerInfo 百家云合作者参数
     * @param roomId [必填] room_id 教室号
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_45_DOC_GET_PREVIEW_INFO)
    BjyResult<Void> getPreviewInfo(BjyPartnerInfo partnerInfo, @RequestParam("room_id") String roomId);

    /**
     * API 49 : 通过文档ID获取文档课件预览接口
     * @param partnerInfo 百家云合作者参数
     * @param fid [必填] fid 文档ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_49_DOC_GET_PREVIEW_INFO_BY_FID)
    BjyResult<Void> getPreviewInfoByFid(BjyPartnerInfo partnerInfo, String fid);

    /**
     * API 50 : 获取账号下已上传的所有音视频课件接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_50_DOC_LIST_ALL_VIDEO_DOC)
    BjyResult<Void> listAllVideoDoc(BjyPartnerInfo partnerInfo, ListAllVideoDocReq req);

    /**
     * API 51 : 重命名课件接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_51_DOC_UPDATE_DOC)
    BjyResult<Void> updateDoc(BjyPartnerInfo partnerInfo, UpdateDocReq req);

    /**
     * API 52 : 删除课件接口
     * @param partnerInfo 百家云合作者参数
     * @param fid [必填] fid 文档ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_52_DOC_DESTROY_DOC)
    BjyResult<Void> destroyDoc(BjyPartnerInfo partnerInfo, String fid);

    /**
     * API 53 : 关联音视频文档到教室接口
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_53_DOC_BIND_VIDEO_DOC)
    BjyResult<Void> bindVideoDoc(BjyPartnerInfo partnerInfo, BindVideoDocReq req);

    /**
     * API 1 : 设置教室内网页PPT
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_DOC_SET_WEB_PPT)
    BjyResult<IdResp> setWebPpt(BjyPartnerInfo partnerInfo, SetWebPptReq req);

    /**
     * API 2 : 获取教室内设置的网页PPT
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_DOC_GET_WEB_PPT)
    BjyResult<GetWebPptResp> getWebPpt(BjyPartnerInfo partnerInfo, GetWebPptReq req);

    /**
     * API 3 : 删除教室内设置的网页PPT
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_DOC_DELETE_WEB_PPT)
    BjyResult<Void> deleteWebPpt(BjyPartnerInfo partnerInfo, DeleteWebPptReq req);

    /**
     * 获取课件下载地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.GET, path = BjyUrls.API_X_DOC_GET_ROOM_DOC_URL)
    BjyResult<Void> getRoomDocUrl(BjyPartnerInfo partnerInfo, GetRoomDocUrlReq req);

    /**
     * API 1 : 新东方定制 - 批量关联文档到教室
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_1_DOC_BATCH_BIND_DOC)
    BjyResult<Void> batchBindDoc(BjyPartnerInfo partnerInfo, BatchBindDocReq req);

    /**
     * API 2 : 新东方定制 - 批量移除教室内文档
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_DOC_BATCH_REMOVE_DOC)
    BjyResult<Void> batchRemoveDoc(BjyPartnerInfo partnerInfo, BatchRemoveDocReq req);

    /**
     * API 3 : 通过文档ID获取音视频课件预览接口
     * @param partnerInfo 百家云合作者参数
     * @param fid [必填] fid 文档ID
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_DOC_GET_VIDEO_PREVIEW_INFO_BY_FID)
    BjyResult<Void> getVideoPreviewInfoByFid(BjyPartnerInfo partnerInfo, String fid);

    /**
     * 获取直播音视频课件上传地址
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_X_DOC_GET_VIDEO_DOC_UPLOAD_URL)
    BjyResult<Void> getVideoDocUploadUrl(BjyPartnerInfo partnerInfo, GetVideoDocUploadUrlReq req);
}