package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.classgoods.*;

/**
 * Auto generate interface of ClassGoodsApi.
 */
@BjyClient
public interface ClassGoodsApi {

    /**
     * API 2 : 直播带货模板的教室添加商品
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_2_CLASS_GOODS_ADD_GOODS)
    BjyResult<AddGoodsResp> addGoods(BjyPartnerInfo partnerInfo, AddGoodsReq req);

    /**
     * API 3 : 直播带货模板的教室编辑商品
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_3_CLASS_GOODS_EDIT_GOODS)
    BjyResult<Void> editGoods(BjyPartnerInfo partnerInfo, EditGoodsReq req);

    /**
     * API 4 : 直播带货模板的教室删除商品
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_4_CLASS_GOODS_DELETE_GOODS)
    BjyResult<Void> deleteGoods(BjyPartnerInfo partnerInfo, DeleteGoodsReq req);
}