package com.baijiayun.openapi.sdk.api;

import com.baijiayun.openapi.sdk.BjyUrls;
import com.baijiayun.openapi.sdk.base.*;
import com.baijiayun.openapi.sdk.dto.account.*;

/**
 * Auto generate interface of AccountApi.
 */
@BjyClient
public interface AccountApi {

    /**
     * API 27 : 设置超级账号回调地址配置
     * @param partnerInfo 百家云合作者参数
     * @param req 请求参数
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_27_ACCOUNT_SET_CALLBACK_URL)
    BjyResult<Void> setCallbackUrl(BjyPartnerInfo partnerInfo, SetCallbackUrlReq req);

    /**
     * API 26 : 查询超级账号回调地址配置
     * @param partnerInfo 百家云合作者参数
     * @param type 回调地址类型，多个逗号分隔，不传则返回全部，具体类型见说明
     * @return 请求结果
     */
    @Request(method = Request.Method.POST, path = BjyUrls.API_26_ACCOUNT_GET_CALLBACK_URL)
    BjyResult<Void> getCallbackUrl(BjyPartnerInfo partnerInfo, String type);
}