package com.baijiayun.openapi.sdk.base;

import lombok.Data;

import java.io.Serializable;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/6/28
 */
@Data
public class BjyPartnerInfo implements Serializable {
    private static final long serialVersionUID = -1L;
    private String partnerId;
    private String partnerKey;
    private String privateDomain;
    private Long bizId;

    private String customDomain;

    private String systemDomain;

    private Integer securityLevel;
    /**
     * 获取直播跳转域名
     *
     * 这个域名是用来返回给客户浏览器，跳转到百家云直播间的。
     *
     * @return
     */
    public String getLiveDomain() {
        // 若商户自定义了直播域名，就优先使用
        if (customDomain != null) {
            return customDomain;
        }
        // 如果系统有配置自定义域名，则统一用系统的域名。
        if (systemDomain != null) {
            return systemDomain;
        }
        // 两个都没有，就直接使用百家云提供的域名。
        return privateDomain;
    }
}
