/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.office.service.impl;

import com.baijia.component.permission.util.BaseUtils;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.util.upload.StorageUtil;
import com.baijia.wedo.dal.office.dao.UserSigninDao;
import com.baijia.wedo.dal.office.dto.SearchUserSigninReqDto;
import com.baijia.wedo.dal.office.po.UserSignin;
import com.baijia.wedo.dal.upload.dao.StorageDao;
import com.baijia.wedo.dal.upload.po.Storage;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.office.dto.SearchUserSigninRespDto;
import com.baijia.wedo.sal.office.dto.UserSigninReqDto;
import com.baijia.wedo.sal.office.service.UserSigninService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserSigninServiceImpl
implements UserSigninService {
    @Autowired
    private UserSigninDao userSigninDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private StorageDao storageDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long saveUserSignin(long userId, UserSigninReqDto dto) {
        UserSignin userSign = new UserSignin();
        userSign.setUserId(Long.valueOf(userId));
        UserSigninReqDto.toUserSignin(dto, userSign);
        this.userSigninDao.save((Object)userSign, new String[0]);
        return userSign.getId();
    }

    @Override
    public long getSigninCountByUserId(long userId) {
        return this.userSigninDao.getSigninCountByUserId(userId);
    }

    @Override
    public List<SearchUserSigninRespDto> search(SearchUserSigninReqDto params, PageDto pageDto) {
        List signins;
        ArrayList signinRespDtos = Lists.newArrayList();
        Set userIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)params.getQuery())) {
            List users = this.userDao.getByNameOrMobile(params.getQuery());
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                userIds = BaseUtils.getPropertiesList((List)users, (String)"id");
            } else {
                return signinRespDtos;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(signins = this.userSigninDao.getSigninByParams(params, (Collection)userIds, pageDto)))) {
            Set finalUserIds = BaseUtils.getPropertiesList((List)signins, (String)"userId");
            List finalUsers = this.userDao.getByIds((Collection)finalUserIds, new String[0]);
            HashMap finalUserMap = Maps.newHashMap();
            for (User user : finalUsers) {
                finalUserMap.put(user.getId(), user);
            }
            for (UserSignin signin : signins) {
                SearchUserSigninRespDto signRespDto;
                User user = (User)finalUserMap.get((signRespDto = SearchUserSigninRespDto.from(signin)).getUserId());
                signRespDto.setUserName(null != user ? user.getName() : "");
                signinRespDtos.add(signRespDto);
            }
            this.populatePics(signinRespDtos);
        }
        return signinRespDtos;
    }

    @Override
    public List<SearchUserSigninRespDto> searchByUser(Long userId, SearchUserSigninReqDto params, PageDto pageDto) {
        ArrayList signinRespDtos = Lists.newArrayList();
        List signins = this.userSigninDao.getSigninByParams(params, (Collection)Sets.newHashSet((Object[])new Long[]{userId}), pageDto);
        if (CollectionUtils.isNotEmpty((Collection)signins)) {
            Set finalUserIds = BaseUtils.getPropertiesList((List)signins, (String)"userId");
            List finalUsers = this.userDao.getByIds((Collection)finalUserIds, new String[0]);
            HashMap finalUserMap = Maps.newHashMap();
            for (User user : finalUsers) {
                finalUserMap.put(user.getId(), user);
            }
            for (UserSignin signin : signins) {
                SearchUserSigninRespDto signRespDto;
                User user = (User)finalUserMap.get((signRespDto = SearchUserSigninRespDto.from(signin)).getUserId());
                signRespDto.setUserName(null != user ? user.getName() : "");
                signinRespDtos.add(signRespDto);
            }
            this.populatePics(signinRespDtos);
        }
        return signinRespDtos;
    }

    private void populatePics(List<SearchUserSigninRespDto> signinRespDtos) {
        HashSet storageIds = Sets.newHashSet();
        HashMap userSignin2StorageIds = Maps.newHashMap();
        for (SearchUserSigninRespDto signinRespDto : signinRespDtos) {
            if (!StringUtils.isNotBlank((String)signinRespDto.getStorageIds())) continue;
            HashSet storageIdsOfSignin = Sets.newHashSet();
            userSignin2StorageIds.put(signinRespDto.getId(), storageIdsOfSignin);
            String[] storageIdStrArray = signinRespDto.getStorageIds().split(",");
            if (null == storageIdStrArray) continue;
            for (String storageIdStr : storageIdStrArray) {
                try {
                    Long storageId = Long.parseLong(storageIdStr);
                    storageIds.add(storageId);
                    storageIdsOfSignin.add(storageId);
                }
                catch (NumberFormatException storageId) {
                    // empty catch block
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)storageIds)) {
            List storages = this.storageDao.getByIds((Collection)storageIds, new String[0]);
            HashMap storageid2Pic = Maps.newHashMap();
            for (Storage storage : storages) {
                storageid2Pic.put(storage.getId(), StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimetype()));
            }
            for (SearchUserSigninRespDto signinRespDto : signinRespDtos) {
                Set storageIdsOfSignin = (Set)userSignin2StorageIds.get(signinRespDto.getId());
                if (!CollectionUtils.isNotEmpty((Collection)storageIdsOfSignin)) continue;
                StringBuilder picBuilder = new StringBuilder();
                for (Long storageId : storageIdsOfSignin) {
                    String pic = (String)storageid2Pic.get(storageId);
                    if (!StringUtils.isNotBlank((String)pic)) continue;
                    picBuilder.append(",");
                    picBuilder.append(pic);
                }
                if (picBuilder.length() > 0) {
                    picBuilder.deleteCharAt(0);
                }
                signinRespDto.setPics(picBuilder.toString());
            }
        }
    }
}

