/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.office.service.impl;

import com.baijia.wedo.common.enums.PermissionCode;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.office.dao.StudentSigninDao;
import com.baijia.wedo.dal.office.po.StudentSignin;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.sal.office.dto.StudentSigninReqDto;
import com.baijia.wedo.sal.office.service.StudentSigninService;
import java.util.Date;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentSigninServiceImpl
implements StudentSigninService {
    @Autowired
    private StudentSigninDao studentSigninDao;
    @Autowired
    private StudentDao studentDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long saveStudentSignin(long userId, StudentSigninReqDto dto) {
        Student student = this.studentDao.getStudentById(dto.getStudentId().longValue());
        if (student == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5b66\u5458\u4e0d\u5b58\u5728");
        }
        if (!(dto.getSigninTime() != null && dto.getSigninTime() != NumberUtils.LONG_ZERO || dto.getLeaveTime() != null && dto.getLeaveTime() != NumberUtils.LONG_ZERO)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u6ca1\u6709\u7b7e\u5230\u65f6\u95f4");
        }
        BaseLoginUser user = LoginUtil.getCurrentUser();
        Date signinDate = DateUtils.truncate((Date)new Date(dto.getDate()), (int)5);
        Date currentDate = DateUtils.truncate((Date)new Date(), (int)5);
        if (!user.getPermissions().contains(PermissionCode.STUDENT_ALL_SIGNIN_EDIT.getName()) && !DateUtils.isSameDay((Date)currentDate, (Date)signinDate)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u65e0\u6743\u7f16\u8f91\u5386\u53f2\u7684\u7b7e\u5230\u8bb0\u5f55");
        }
        StudentSignin studentSignin = this.studentSigninDao.getStudentSigninByDate(signinDate, student.getId().longValue());
        if (studentSignin == null) {
            studentSignin = new StudentSignin();
            studentSignin.setSigninDate(signinDate);
        }
        if (dto.getSigninTime() != null && dto.getSigninTime() != NumberUtils.LONG_ZERO) {
            Date signinTime = new Date(dto.getSigninTime());
            if (!DateUtils.isSameDay((Date)signinDate, (Date)signinTime)) {
                throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u5230\u6821\u65f6\u95f4\u586b\u5199\u9519\u8bef");
            }
            studentSignin.setSigninTime(signinTime);
        }
        if (dto.getLeaveTime() != null && dto.getLeaveTime() != NumberUtils.LONG_ZERO) {
            Date leaveTime = new Date(dto.getLeaveTime());
            if (!DateUtils.isSameDay((Date)signinDate, (Date)leaveTime)) {
                throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u79bb\u6821\u65f6\u95f4\u586b\u5199\u9519\u8bef");
            }
            studentSignin.setLeaveTime(leaveTime);
        }
        studentSignin.setStudentId(student.getId());
        studentSignin.setUserId(Long.valueOf(userId));
        if (studentSignin.getId() == null) {
            this.studentSigninDao.save((Object)studentSignin, new String[0]);
        } else {
            this.studentSigninDao.update((Object)studentSignin, new String[0]);
        }
        return studentSignin.getId();
    }
}

