/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.office.service.impl;

import com.baijia.wedo.common.enums.CommentStatus;
import com.baijia.wedo.common.enums.MessageBizType;
import com.baijia.wedo.common.enums.UserRole;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.office.dao.LessonCommentDao;
import com.baijia.wedo.dal.office.dao.TeacherStudentCommentDao;
import com.baijia.wedo.dal.office.dto.TeacherStudentCommentDto;
import com.baijia.wedo.dal.office.po.LessonComment;
import com.baijia.wedo.dal.office.po.TeacherStudentComment;
import com.baijia.wedo.dal.schedule.dao.OrgClassLessonDao;
import com.baijia.wedo.dal.schedule.dao.OrgTeacherLessonDao;
import com.baijia.wedo.dal.schedule.po.OrgClassLesson;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.dal.wechat.dao.WechatMobileDao;
import com.baijia.wedo.dal.wechat.po.WechatMobile;
import com.baijia.wedo.sal.office.dto.LessonCommentReqDto;
import com.baijia.wedo.sal.office.service.LessonCommentService;
import com.baijia.wedo.sal.wechat.dto.SendMsgRequest;
import com.baijia.wedo.sal.wechat.enums.WechatTemplateMsgType;
import com.baijia.wedo.sal.wechat.service.MsgSendService;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LessonCommentServiceImpl
implements LessonCommentService {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentServiceImpl.class);
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private LessonCommentDao lessonCommentDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private TeacherStudentCommentDao teacherStudentCommentDao;
    @Autowired
    private MsgSendService msgSendService;
    @Autowired
    private WechatMobileDao wechatMobileDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private UserDao userDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long comment(long userId, LessonCommentReqDto dto) {
        if (dto.getLessonId() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8bf7\u9009\u62e9\u8bfe\u8282");
        }
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)dto.getLessonId(), new String[0]);
        if (lesson == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728");
        }
        List teacherLessons = this.orgTeacherLessonDao.getByLessonId(lesson.getId());
        if (CollectionUtils.isEmpty((Collection)teacherLessons)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8001\u5e08\u65e0\u6743\u53cd\u9988\u8be5\u8bfe\u8282");
        }
        Set teacherIds = BaseUtils.getPropertiesList((Collection)teacherLessons, (String)"teacherId");
        if (CollectionUtils.isEmpty((Collection)teacherIds) || !teacherIds.contains(userId)) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8001\u5e08\u65e0\u6743\u53cd\u9988\u8be5\u8bfe\u8282");
        }
        LessonComment comment = this.lessonCommentDao.getCommentByLesson(dto.getLessonId().longValue());
        Date now = new Date();
        if (comment != null) {
            LessonCommentReqDto.toLessonComment(comment, dto);
            comment.setUpdateTime(now);
            this.lessonCommentDao.update((Object)comment, new String[0]);
        } else {
            comment = new LessonComment();
            LessonCommentReqDto.toLessonComment(comment, dto);
            comment.setStatus(CommentStatus.COMMENT.getStatus());
            comment.setCreateTime(now);
            comment.setUpdateTime(now);
            comment.setCreatorId(userId);
            this.lessonCommentDao.save((Object)comment, new String[0]);
        }
        return comment.getId();
    }

    @Override
    public LessonCommentReqDto getCommentDetail(long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)Long.valueOf(lessonId), new String[0]);
        if (lesson == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728");
        }
        LessonComment comment = this.lessonCommentDao.getCommentByLesson(lesson.getId().longValue());
        LessonCommentReqDto dto = new LessonCommentReqDto();
        if (comment != null) {
            LessonCommentReqDto.toDto(comment, dto);
        } else {
            dto.setLessonId(lessonId);
            dto.setStatus(CommentStatus.UNCOMMENT.getStatus());
        }
        return dto;
    }

    @Override
    public Map<Long, LessonCommentReqDto> getCommentDetailAndCache(Collection<Long> lessonIds) {
        Map lessonCommentReqDtoMap = Maps.newHashMap();
        List lessonCommentList = this.lessonCommentDao.getCommentByLessonIds(lessonIds);
        if (CollectionUtils.isNotEmpty((Collection)lessonCommentList)) {
            for (LessonComment lessonComment : lessonCommentList) {
                LessonCommentReqDto lessonCommentReqDto = new LessonCommentReqDto();
                LessonCommentReqDto.toDto(lessonComment, lessonCommentReqDto);
                lessonCommentReqDtoMap.put(lessonComment.getLessonId(), lessonCommentReqDto);
            }
        }
        return lessonCommentReqDtoMap;
    }

    @Override
    public TeacherStudentCommentDto getLessonStudentComment(long id) {
        TeacherStudentComment comment = (TeacherStudentComment)this.teacherStudentCommentDao.getById((Serializable)Long.valueOf(id), new String[0]);
        TeacherStudentCommentDto dto = null;
        if (comment != null) {
            dto = TeacherStudentCommentDto.toDto((TeacherStudentComment)comment);
        }
        return dto;
    }

    @Override
    public long comment(long userId, TeacherStudentCommentDto dto) {
        if (dto.getLessonId() == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8bf7\u9009\u62e9\u8bfe\u8282");
        }
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)dto.getLessonId(), new String[0]);
        if (lesson == null) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728");
        }
        if (!this.orgTeacherLessonDao.isTeacherInLesson(dto.getLessonId(), Long.valueOf(userId))) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PARAM_ERROR, "\u8001\u5e08\u65e0\u6743\u5bf9\u8be5\u8bfe\u8282\u505a\u8bc4\u4ef7");
        }
        TeacherStudentComment comment = this.teacherStudentCommentDao.getCommentByStudentIdAndLessonId(userId, dto.getLessonId().longValue(), dto.getStudentId().longValue());
        if (comment != null) {
            TeacherStudentCommentDto.toPo((TeacherStudentComment)comment, (TeacherStudentCommentDto)dto);
            comment.setUpdateTime(new Date());
            this.teacherStudentCommentDao.update((Object)comment, new String[0]);
        } else {
            comment = new TeacherStudentComment();
            TeacherStudentCommentDto.toPo((TeacherStudentComment)comment, (TeacherStudentCommentDto)dto);
            comment.setUpdateTime(new Date());
            comment.setCreateTime(new Date());
            this.teacherStudentCommentDao.save((Object)comment, new String[0]);
        }
        BaseLoginUser user = LoginUtil.getCurrentUser();
        this.sendTemplateMsgToStudent(dto.getStudentId(), user.getUserName(), dto.getComment());
        this.sendTemplateMsgToParent(dto.getStudentId(), user.getUserName(), dto.getComment());
        this.sendTemplateMsgToTeacher(dto.getStudentId(), user, dto.getComment());
        return 0L;
    }

    void sendWechatMsg(String openId, String studentName, String userName, String content, int userRole, MessageBizType bizType, WechatTemplateMsgType templateType) {
        if (StringUtils.isNotBlank((String)openId)) {
            try {
                String first = "";
                if (userRole == UserRole.STUDENT.getRole()) {
                    first = String.format("%s\u540c\u5b66\uff0c\u4f60\u597d,%s\u8001\u5e08\u5bf9\u4f60\u7684\u8bfe\u5802\u8868\u73b0\u505a\u4e86\u8bc4\u4ef7\uff0c\u8bf7\u767b\u5f55\u5b66\u5458\u4e2d\u5fc3\u67e5\u770b\u8be6\u60c5", studentName, userName);
                } else if (userRole == UserRole.PARENT.getRole()) {
                    first = String.format("%s\u5bb6\u957f\uff0c\u60a8\u597d,%s\u8001\u5e08\u5bf9%s\u7684\u8bfe\u5802\u8868\u73b0\u505a\u4e86\u8bc4\u4ef7\uff0c\u8bf7\u767b\u5f55\u5bb6\u957f\u4e2d\u5fc3\u67e5\u770b\u8be6\u60c5", studentName, userName, studentName);
                } else if (userRole == UserRole.TEACHER.getRole()) {
                    first = String.format("%s\u8001\u5e08\uff0c\u60a8\u597d,\u60a8\u5bf9%s\u540c\u5b66\u7684\u8bfe\u5802\u8868\u73b0\u505a\u4e86\u8bc4\u4ef7\uff0c\u8be6\u60c5\u8bf7\u767b\u5f55\u5458\u5de5\u4e2d\u5fc3\u67e5\u770b", userName, studentName);
                } else if (userRole == UserRole.STAFF.getRole()) {
                    first = String.format("\u8001\u5e08\uff0c\u60a8\u597d,%s\u8001\u5e08\u5bf9%s\u540c\u5b66\u7684\u8bfe\u5802\u8868\u73b0\u505a\u4e86\u8bc4\u4ef7\uff0c\u8be6\u60c5\u8bf7\u767b\u5f55\u8001\u5e08\u4e2d\u5fc3\u67e5\u770b", userName, studentName);
                } else {
                    return;
                }
                String keyword1 = bizType.getTitle();
                String keyword2 = "WEDO-" + String.format("%03d", bizType.getType());
                String keyword3 = content;
                SendMsgRequest request = this.getMsgParam(openId, templateType, first, keyword1, keyword2, keyword3, "", "");
                if (log.isDebugEnabled()) {
                    log.debug("Send wechat message:{}", (Object)request);
                }
                this.msgSendService.sendMsg(request);
            }
            catch (Throwable e) {
                log.warn("Send wechat message to user failed, openId:{}, studentName:{}, userName:{}, content:{}", new Object[]{openId, studentName, userName, content});
            }
        }
    }

    void sendTemplateMsgToStudent(long studentId, String userName, String content) {
        List wechatStudents = this.wechatMobileDao.getWechatMobiles(null, Long.valueOf(studentId), Integer.valueOf(UserRole.STUDENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatStudents)) {
            Set studentIds = BaseUtils.getPropertiesList((Collection)wechatStudents, (String)"userId");
            List students = this.studentDao.getByIds((Collection)studentIds, new String[]{"id", "name"});
            Map cache = BaseUtils.listToMap((List)students, (String)"id");
            for (WechatMobile wechatStudent : wechatStudents) {
                Student student = (Student)cache.get(wechatStudent.getUserId());
                if (student == null) continue;
                this.sendWechatMsg(wechatStudent.getWeixinOpenId(), student.getName(), userName, content, UserRole.STUDENT.getRole(), MessageBizType.LESSON_COMMENT, WechatTemplateMsgType.STUDENT_NOTIFY);
            }
        }
    }

    void sendTemplateMsgToParent(long studentId, String userName, String content) {
        List wechatStudents = this.wechatMobileDao.getWechatMobiles(null, Long.valueOf(studentId), Integer.valueOf(UserRole.PARENT.getRole()));
        if (CollectionUtils.isNotEmpty((Collection)wechatStudents)) {
            Set studentIds = BaseUtils.getPropertiesList((Collection)wechatStudents, (String)"userId");
            List students = this.studentDao.getByIds((Collection)studentIds, new String[]{"id", "name"});
            Map cache = BaseUtils.listToMap((List)students, (String)"id");
            for (WechatMobile wechatStudent : wechatStudents) {
                Student student = (Student)cache.get(wechatStudent.getUserId());
                if (student == null) continue;
                this.sendWechatMsg(wechatStudent.getWeixinOpenId(), student.getName(), userName, content, UserRole.PARENT.getRole(), MessageBizType.LESSON_COMMENT, WechatTemplateMsgType.STUDENT_NOTIFY);
            }
        }
    }

    void sendTemplateMsgToTeacher(long studentId, BaseLoginUser user, String content) {
        User assistant;
        Student student = (Student)this.studentDao.getById((Serializable)Long.valueOf(studentId), new String[]{"id", "name"});
        User teacher = (User)this.userDao.getById((Serializable)user.getUserId(), new String[]{"id", "name", "weixinOpenId"});
        if (teacher != null && StringUtils.isNotBlank((String)teacher.getWeixinOpenId())) {
            this.sendWechatMsg(teacher.getWeixinOpenId(), student.getName(), user.getUserName(), content, UserRole.TEACHER.getRole(), MessageBizType.LESSON_COMMENT, WechatTemplateMsgType.STAFF_NOTIFY);
        }
        if (student.getAssistantId() > 0L && (assistant = (User)this.userDao.getById((Serializable)Long.valueOf(student.getAssistantId()), new String[]{"id", "name", "weixinOpenId"})) != null && StringUtils.isNotBlank((String)assistant.getWeixinOpenId())) {
            this.sendWechatMsg(assistant.getWeixinOpenId(), student.getName(), user.getUserName(), content, UserRole.STAFF.getRole(), MessageBizType.LESSON_COMMENT, WechatTemplateMsgType.STAFF_NOTIFY);
        }
    }

    private SendMsgRequest getMsgParam(String weixinOpenId, WechatTemplateMsgType msgType, String first, String keyword1, String keyword2, String keyword3, String url, String remark) {
        SendMsgRequest request = new SendMsgRequest();
        Map params = Maps.newHashMap();
        params.put("first", first);
        params.put("keyword1", keyword1);
        params.put("keyword2", keyword2);
        params.put("keyword3", keyword3);
        params.put("remark", remark);
        params.put("url", url);
        request.setWeixinOpenId(weixinOpenId);
        request.setTemplateType(msgType);
        request.setParams(params);
        return request;
    }
}

