/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.office.dto;

import com.baijia.wedo.common.util.JacksonUtil;
import com.baijia.wedo.dal.office.dto.LessonCommentDto;
import com.baijia.wedo.dal.office.po.LessonComment;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessonCommentReqDto {
    private static final Logger log = LoggerFactory.getLogger(LessonCommentReqDto.class);
    private Long id;
    private Long lessonId;
    private Long teacherId;
    private String content;
    private LessonCommentDto comment;
    private Integer status;

    public static void toLessonComment(LessonComment comment, LessonCommentReqDto dto) {
        comment.setId(dto.getId());
        comment.setTeacherId(dto.getTeacherId().longValue());
        comment.setLessonId(dto.getLessonId().longValue());
        comment.setStatus(dto.getStatus().intValue());
        if (dto.getComment() != null) {
            comment.setContent(JacksonUtil.obj2Str((Object)dto.getComment()));
        }
    }

    public static void toDto(LessonComment comment, LessonCommentReqDto dto) {
        dto.setId(comment.getId());
        dto.setLessonId(comment.getLessonId());
        dto.setStatus(comment.getStatus());
        dto.setTeacherId(comment.getTeacherId());
        if (StringUtils.isNotBlank((CharSequence)comment.getContent())) {
            try {
                dto.setComment((LessonCommentDto)JacksonUtil.str2Obj((String)comment.getContent(), LessonCommentDto.class));
            }
            catch (Exception e) {
                log.error("parase str to comment failed, content:{}, e:{}", (Object)comment.getContent(), (Object)e);
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getLessonId() {
        return this.lessonId;
    }

    public Long getTeacherId() {
        return this.teacherId;
    }

    public String getContent() {
        return this.content;
    }

    public LessonCommentDto getComment() {
        return this.comment;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLessonId(Long lessonId) {
        this.lessonId = lessonId;
    }

    public void setTeacherId(Long teacherId) {
        this.teacherId = teacherId;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setComment(LessonCommentDto comment) {
        this.comment = comment;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LessonCommentReqDto)) {
            return false;
        }
        LessonCommentReqDto other = (LessonCommentReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$lessonId = this.getLessonId();
        Long other$lessonId = other.getLessonId();
        if (this$lessonId == null ? other$lessonId != null : !((Object)this$lessonId).equals(other$lessonId)) {
            return false;
        }
        Long this$teacherId = this.getTeacherId();
        Long other$teacherId = other.getTeacherId();
        if (this$teacherId == null ? other$teacherId != null : !((Object)this$teacherId).equals(other$teacherId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        LessonCommentDto this$comment = this.getComment();
        LessonCommentDto other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)this$status).equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LessonCommentReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $lessonId = this.getLessonId();
        result = result * 59 + ($lessonId == null ? 43 : ((Object)$lessonId).hashCode());
        Long $teacherId = this.getTeacherId();
        result = result * 59 + ($teacherId == null ? 43 : ((Object)$teacherId).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        LessonCommentDto $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        return result;
    }

    public String toString() {
        return "LessonCommentReqDto(id=" + this.getId() + ", lessonId=" + this.getLessonId() + ", teacherId=" + this.getTeacherId() + ", content=" + this.getContent() + ", comment=" + this.getComment() + ", status=" + this.getStatus() + ")";
    }
}

