/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.message.service.impl;

import com.baijia.wedo.common.enums.MessageBizType;
import com.baijia.wedo.common.enums.MessageType;
import com.baijia.wedo.common.enums.ReadStatus;
import com.baijia.wedo.dal.message.dao.MessageInfoDao;
import com.baijia.wedo.dal.message.dao.MessageReceiveDao;
import com.baijia.wedo.dal.message.po.MessageInfo;
import com.baijia.wedo.dal.message.po.MessageReceive;
import com.baijia.wedo.dal.student.dao.ClueDao;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.message.dto.MessageSend;
import com.baijia.wedo.sal.message.service.MessageSendService;
import com.baijia.wedo.sal.wechat.dto.SendMsgRequest;
import com.baijia.wedo.sal.wechat.enums.WechatTemplateMsgType;
import com.baijia.wedo.sal.wechat.service.MsgSendService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="messageSendService")
public class MessageSendServiceImpl
implements MessageSendService {
    private static final Logger log = LoggerFactory.getLogger(MessageSendServiceImpl.class);
    @Resource
    private MessageInfoDao messageInfoDao;
    @Resource
    private MessageReceiveDao messageReceiveDao;
    @Autowired
    private ClueDao clueDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private MsgSendService msgSendService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sendMessage(MessageSend messageSend) {
        this.saveSendInfo(messageSend.getMessageInfo());
        Collection<MessageReceive> receive = this.createReceive(messageSend);
        this.saveReceive(receive);
        return true;
    }

    public void sendWechatMessage(MessageSend messageSend) {
        try {
            MessageBizType bizType = MessageBizType.get((int)messageSend.getMessageInfo().getBizType());
            if (bizType == null) {
                return;
            }
            Collection<Long> receiveUids = messageSend.getReceiverUids();
            if (CollectionUtils.isNotEmpty(receiveUids)) {
                List users = this.userDao.getUsersByIds(receiveUids, new String[0]);
                for (User user : users) {
                    if (!StringUtils.isNotBlank((CharSequence)user.getWeixinOpenId()) || !StringUtils.isNotBlank((CharSequence)user.getName())) continue;
                    try {
                        String first = String.format("%s\uff0c\u60a8\u597d\u3002\u60a8\u6709\u4e00\u4e2a\u91cd\u8981\u901a\u77e5\uff0c\u5185\u5bb9\u5982\u4e0b\uff1a", user.getName());
                        String keyword1 = bizType.getTitle();
                        String keyword2 = "WEDO-" + String.format("%03d", bizType.getType());
                        String keyword3 = messageSend.getMessageInfo().getContent();
                        SendMsgRequest request = this.getMsgParam(user.getWeixinOpenId(), WechatTemplateMsgType.STAFF_NOTIFY, first, keyword1, keyword2, keyword3, "", "");
                        if (log.isDebugEnabled()) {
                            log.debug("Send wechat message:{}", (Object)request);
                        }
                        this.msgSendService.sendMsg(request);
                    }
                    catch (Throwable e) {
                        log.warn("Send wechat message:" + messageSend + " to user:" + user + " failed...", e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.error("Send wechat message:" + messageSend + " failed...", e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createUserMessage(Collection<Long> receiverUids, String content, Long senderUid, String senderUname) {
        if (CollectionUtils.isEmpty(receiverUids)) {
            throw new RuntimeException("\u7ad9\u5185\u6d88\u606f\u7684\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MessageSend messageSend = new MessageSend();
        MessageInfo minfo = new MessageInfo();
        minfo.setType(MessageType.user.name());
        minfo.setTypeName(MessageType.user.getTypeName());
        minfo.setCreateTime(new Date());
        minfo.setStatus(Integer.valueOf(1));
        minfo.setContent(content);
        if (senderUid != null) {
            minfo.setSenderUid(senderUid);
            minfo.setSenderUname(senderUname);
        } else {
            minfo.setSenderUid(Long.valueOf(888888L));
            minfo.setSenderUname("\u7cfb\u7edf");
        }
        messageSend.setMessageInfo(minfo);
        messageSend.setReceiverUids(receiverUids);
        return this.sendMessage(messageSend);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createNotifyMessage(Collection<Long> receiverUids, String content, MessageBizType bizType, String bizKey) {
        if (CollectionUtils.isEmpty(receiverUids)) {
            throw new RuntimeException("\u7ad9\u5185\u6d88\u606f\u7684\u63a5\u53d7\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MessageSend messageSend = new MessageSend();
        MessageInfo minfo = new MessageInfo();
        minfo.setType(MessageType.notify.name());
        minfo.setTypeName(MessageType.notify.getTypeName());
        minfo.setBizType(bizType.getType());
        minfo.setBizKey(bizKey);
        minfo.setCreateTime(new Date());
        minfo.setStatus(Integer.valueOf(1));
        minfo.setContent(content);
        minfo.setSenderUid(Long.valueOf(888888L));
        minfo.setSenderUname("\u7cfb\u7edf");
        messageSend.setMessageInfo(minfo);
        messageSend.setReceiverUids(receiverUids);
        this.sendMessage(messageSend);
        if (bizType.isSendWechatMsg()) {
            this.sendWechatMessage(messageSend);
        }
        return true;
    }

    private Collection<MessageReceive> createReceive(MessageSend messageSend) {
        Long messageInfoId = messageSend.getMessageInfo().getId();
        Date date = messageSend.getMessageInfo().getCreateTime();
        String type = messageSend.getMessageInfo().getType();
        ArrayList<MessageReceive> list = new ArrayList<MessageReceive>();
        HashSet rcvIds = Sets.newHashSet();
        for (Long uid : messageSend.getReceiverUids()) {
            if (uid == null || uid <= 0L) continue;
            rcvIds.add(uid);
            MessageReceive rec = new MessageReceive();
            rec.setReceiverUid(uid);
            rec.setMessageInfoId(messageInfoId);
            rec.setReadStatus(Integer.valueOf(ReadStatus.UNREAD.getStatus()));
            rec.setStatus(Integer.valueOf(1));
            rec.setType(type);
            rec.setCreateTime(date);
            list.add(rec);
        }
        messageSend.setReceiverUids(rcvIds);
        return list;
    }

    private void saveSendInfo(MessageInfo messageInfo) {
        this.messageInfoDao.save((Object)messageInfo, new String[0]);
    }

    private void saveReceive(Collection<MessageReceive> receiveList) {
        if (CollectionUtils.isNotEmpty(receiveList)) {
            this.messageReceiveDao.saveAll((List)Lists.newArrayList(receiveList), new String[0]);
        }
    }

    private SendMsgRequest getMsgParam(String weixinOpenId, WechatTemplateMsgType msgType, String first, String keyword1, String keyword2, String keyword3, String url, String remark) {
        SendMsgRequest request = new SendMsgRequest();
        HashMap params = Maps.newHashMap();
        params.put("first", first);
        params.put("keyword1", keyword1);
        params.put("keyword2", keyword2);
        params.put("keyword3", keyword3);
        params.put("remark", remark);
        params.put("url", url);
        request.setWeixinOpenId(weixinOpenId);
        request.setTemplateType(msgType);
        request.setParams((Map)params);
        return request;
    }

    public static void main(String[] args) {
        System.out.println(String.format("%03d", 0));
        System.out.println(String.format("%03d", 1));
        System.out.println(String.format("%03d", 11));
    }
}

