/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.message.service.impl;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.enums.MessageBizType;
import com.baijia.wedo.common.enums.ReadStatus;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.message.dao.MessageInfoDao;
import com.baijia.wedo.dal.message.dao.MessageReceiveDao;
import com.baijia.wedo.dal.message.po.MessageInfo;
import com.baijia.wedo.dal.message.po.MessageReceive;
import com.baijia.wedo.sal.message.dto.PageInfo;
import com.baijia.wedo.sal.message.dto.QueryMessageRespDto;
import com.baijia.wedo.sal.message.service.MessageQueryService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="messageQueryService")
public class MessageQueryServiceImpl
implements MessageQueryService {
    @Resource
    private MessageInfoDao messageInfoDao;
    @Resource
    private MessageReceiveDao messageReceiverDao;

    @Override
    public List<MessageReceive> queryReceiveMessage(Long uid, Integer read) {
        List<MessageReceive> receiveList = this.getMessageListByReceiveUid(uid, read);
        this.buildInfo(receiveList);
        return receiveList;
    }

    @Override
    public PageInfo<MessageReceive> queryPageReceiveMessage(Long uid, int pageSize, int pageNum) {
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(pageNum));
        page.setPageSize(Integer.valueOf(pageSize));
        List list = this.messageReceiverDao.queryPageByReceiveUid(uid, page);
        PageInfo<MessageReceive> pageInfo = new PageInfo<MessageReceive>(list, page);
        this.buildInfo(pageInfo.getList());
        return pageInfo;
    }

    @Override
    public List<MessageInfo> querySendMessage(Long uid, Integer status) {
        List<MessageInfo> sendList = this.getMessageListBySendUid(uid, status);
        return sendList;
    }

    @Override
    public int queryNewReceiveCount(Long uid) {
        Integer count = this.queryReceiveCount(uid, ReadStatus.UNREAD.getStatus());
        return count;
    }

    private Integer queryReceiveCount(Long uid, Integer read) {
        return this.messageReceiverDao.countByCondition(uid, read);
    }

    private List<MessageReceive> getMessageListByReceiveUid(Long uid, Integer read) {
        List list = this.messageReceiverDao.queryByReceiveUid(uid, read);
        return list;
    }

    private List<MessageInfo> getMessageListBySendUid(Long uid, Integer read) {
        ArrayList<MessageInfo> list = new ArrayList<MessageInfo>();
        return list;
    }

    private Map<Long, MessageInfo> findByMessageInfoIdList(List<Long> ids) {
        HashMap<Long, MessageInfo> map = new HashMap<Long, MessageInfo>();
        if (CollectionUtils.isEmpty(ids)) {
            return map;
        }
        List list = this.messageInfoDao.getByIds(ids, new String[0]);
        for (MessageInfo info : list) {
            map.put(info.getId(), info);
        }
        return map;
    }

    private void buildInfo(List<MessageReceive> list) {
        ArrayList<Long> messageIdList = new ArrayList<Long>();
        for (MessageReceive receive : list) {
            messageIdList.add(receive.getMessageInfoId());
        }
        Map<Long, MessageInfo> map = this.findByMessageInfoIdList(messageIdList);
        Date now = new Date();
        int maxViewMinute = 10;
        for (MessageReceive receive : list) {
            this.getMessageTimeMinute(now, maxViewMinute, receive);
            MessageInfo tempMessageInfo = map.get(receive.getMessageInfoId());
            if (tempMessageInfo == null) continue;
            receive.setMessageInfo(tempMessageInfo);
        }
    }

    private void getMessageTimeMinute(Date now, int maxCalculateMinute, MessageReceive messageReceive) {
        int minute = DateUtil.getMinuteDiff((Date)messageReceive.getCreateTime(), (Date)now);
        if (minute >= maxCalculateMinute) {
            messageReceive.setDateStr(DateUtil.getYYMMDDHHMMStrByDate((Date)messageReceive.getCreateTime()));
        } else if (minute <= 0) {
            messageReceive.setDateStr("\u521a\u521a");
        } else {
            messageReceive.setDateStr("" + minute + "\u5206\u949f\u4ee5\u524d");
        }
        ReadStatus readStatus = ReadStatus.get((int)messageReceive.getReadStatus());
        messageReceive.setStatus(Integer.valueOf(readStatus.getStatus()));
        messageReceive.setStatusStr(readStatus.getLabel());
    }

    @Override
    public boolean readMessage(Long receiverUid, Long readMessageReceiveId) {
        return 1 == this.messageReceiverDao.updateRead(receiverUid, readMessageReceiveId);
    }

    @Override
    public int readMessageBatch(Long receiverUid, List<Long> readMessageReceiveIds) {
        return this.messageReceiverDao.updateReadBatch(receiverUid, readMessageReceiveIds);
    }

    @Override
    public List<MessageReceive> queryNewReceiveMessage(Long uid, Long minId) {
        List list = this.messageReceiverDao.queryByReceiveUidAndMinId(uid, minId, Integer.valueOf(ReadStatus.UNREAD.getStatus()));
        this.buildInfo(list);
        return list;
    }

    @Override
    public List<MessageReceive> queryNewReceiveMessageBell(Long uid) {
        List list = this.messageReceiverDao.queryByReceiveBell(uid, Integer.valueOf(ReadStatus.UNREAD.getStatus()));
        this.buildInfo(list);
        return list;
    }

    @Override
    public List<QueryMessageRespDto> queryMessage(PageDto pageDto) {
        BaseLoginUser user = LoginUtil.getCurrentUser();
        List msgs = this.messageReceiverDao.queryPageByReceiveUid(user.getUserId(), pageDto);
        ArrayList data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)msgs)) {
            Set msgIds = BaseUtils.getPropertiesList((Collection)msgs, (String)"messageInfoId");
            List list = this.messageInfoDao.getByIds((Collection)msgIds, new String[0]);
            Map cache = BaseUtils.listToMap((List)list, (String)"id");
            QueryMessageRespDto item = null;
            for (MessageReceive msgRcv : msgs) {
                item = new QueryMessageRespDto();
                Long messageInfoId = msgRcv.getMessageInfoId();
                if (!cache.containsKey(messageInfoId)) continue;
                MessageInfo info = (MessageInfo)cache.get(messageInfoId);
                item.setContent(info.getContent());
                item.setCreateTime(msgRcv.getCreateTime().getTime());
                item.setId(msgRcv.getId());
                item.setSenderName(info.getSenderUname());
                int status = msgRcv.getReadStatus();
                ReadStatus readStatus = ReadStatus.get((int)status);
                item.setStatus(readStatus.getStatus());
                item.setStatusStr(readStatus.getLabel());
                int bizType = info.getBizType();
                item.setTypeName(MessageBizType.get((int)bizType).getTitle());
                data.add(item);
            }
        }
        return data;
    }
}

