/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.message.service.impl;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.common.enums.ApplyType;
import com.baijia.wedo.common.enums.AuditStatus;
import com.baijia.wedo.common.enums.JoinLessonType;
import com.baijia.wedo.common.enums.MessageBizType;
import com.baijia.wedo.common.enums.RoleType;
import com.baijia.wedo.common.enums.StudentLessonStatus;
import com.baijia.wedo.common.errorcode.CommonErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.BaseLoginUser;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.common.util.LoginUtil;
import com.baijia.wedo.dal.edu.dao.clazz.ClassCourseDetailDao;
import com.baijia.wedo.dal.finance.dao.EnrollCourseDao;
import com.baijia.wedo.dal.finance.dao.EnrollRecordDao;
import com.baijia.wedo.dal.finance.dao.EnrollRefundRecordDao;
import com.baijia.wedo.dal.finance.dao.EnrollStudentLessonDao;
import com.baijia.wedo.dal.finance.dto.EnrollCourseStatisticsDto;
import com.baijia.wedo.dal.finance.po.EnrollCourse;
import com.baijia.wedo.dal.finance.po.EnrollRecord;
import com.baijia.wedo.dal.finance.po.EnrollRefundRecord;
import com.baijia.wedo.dal.finance.po.EnrollStudentLesson;
import com.baijia.wedo.dal.message.dao.AuditRecordDao;
import com.baijia.wedo.dal.message.po.AuditRecord;
import com.baijia.wedo.dal.schedule.dao.OrgClassLessonDao;
import com.baijia.wedo.dal.schedule.dao.OrgLessonConflictDao;
import com.baijia.wedo.dal.schedule.dao.OrgTeacherLessonDao;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.baijia.wedo.dal.system.dao.SchoolDao;
import com.baijia.wedo.dal.system.po.School;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.common.service.UserCommonService;
import com.baijia.wedo.sal.message.dto.AuditRecordListDto;
import com.baijia.wedo.sal.message.service.AuditRecordService;
import com.baijia.wedo.sal.message.service.MessageSendService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditRecordServiceImpl
implements AuditRecordService {
    @Autowired
    private AuditRecordDao auditRecordDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private EnrollRefundRecordDao enrollRefundRecordDao;
    @Autowired
    private EnrollCourseDao enrollCourseDao;
    @Autowired
    private EnrollStudentLessonDao enrollStudentLessonDao;
    @Autowired
    private StudentDao studentDao;
    @Autowired
    private SchoolDao schoolDao;
    @Autowired
    private ClassCourseDetailDao classCourseDetailDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Autowired
    private OrgLessonConflictDao orgLessonConflictDao;
    @Autowired
    private EnrollRecordDao enrollRecordDao;
    @Autowired
    private MessageSendService messageSendService;
    @Autowired
    private UserCommonService userCommonService;

    @Override
    public List<AuditRecordListDto> searchAuditRecord(String query, Integer type, Integer applyType, Integer auditStatus, PageDto pageDto) {
        List records;
        ArrayList data = Lists.newArrayList();
        Set userIds = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            List users = this.userDao.getByNameOrMobile(query);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                userIds = BaseUtils.getPropertiesList((Collection)users, (String)"id");
            } else {
                return data;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(records = this.auditRecordDao.queryAuditRecord((Collection)userIds, applyType, auditStatus, type, pageDto)))) {
            Set<Long> uids = this.getUserIds(records);
            Map<Long, User> cache = this.getAndCacheUser(uids);
            for (AuditRecord record : records) {
                AuditRecordListDto target = AuditRecordListDto.convertToDto(record);
                Long applyId = record.getApplyId();
                Long auditId = record.getAuditId();
                if (cache.containsKey(applyId)) {
                    target.setApplyUserName(cache.get(applyId).getName());
                }
                if (cache.containsKey(auditId)) {
                    target.setAuditUserName(cache.get(auditId).getName());
                }
                data.add(target);
            }
        }
        return data;
    }

    Set<Long> getUserIds(List<AuditRecord> records) {
        HashSet userIds = Sets.newHashSet();
        Set applyIds = BaseUtils.getPropertiesList(records, (String)"applyId");
        Set auditIds = BaseUtils.getPropertiesList(records, (String)"auditId");
        userIds.addAll(applyIds);
        userIds.addAll(auditIds);
        return userIds;
    }

    Map<Long, User> getAndCacheUser(Collection<Long> userIds) {
        Map cache = Maps.newHashMap();
        List users = this.userDao.getByIds(userIds, new String[]{"id", "name"});
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            cache = BaseUtils.listToMap((List)users, (String)"id");
        }
        return cache;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void audit(Long id, int status, String remark) {
        AuditRecord auditRecord = (AuditRecord)this.auditRecordDao.getById((Serializable)id, new String[0]);
        if (auditRecord != null) {
            if (auditRecord.getStatus() != AuditStatus.ONGOING.getStatus()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u5ba1\u6279\u7684\u7533\u8bf7\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279");
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.NOT_EXISTS_OR_DELETED, "\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        BaseLoginUser currentUser = LoginUtil.getCurrentUser();
        Date now = new Date();
        auditRecord.setStatus(status);
        auditRecord.setUpdateTime(now);
        auditRecord.setAuditTime(now);
        auditRecord.setAuditRemarks(remark);
        auditRecord.setAuditId(currentUser.getUserId());
        this.auditRecordDao.update((Object)auditRecord, new String[]{"status", "updateTime", "auditTime", "auditRemarks", "auditId"});
        this.auditAfter(auditRecord, status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void auditAfter(AuditRecord auditRecord, int status) {
        Long targetId = auditRecord.getTargetId();
        if (auditRecord.getApplyType() == ApplyType.AUDIT_REFUND.getType()) {
            EnrollRefundRecord refundRecord = (EnrollRefundRecord)this.enrollRefundRecordDao.getById((Serializable)targetId, new String[0]);
            if (refundRecord == null) return;
            EnrollCourse enrollCourse = (EnrollCourse)this.enrollCourseDao.getById((Serializable)refundRecord.getEnrollCourseId(), new String[0]);
            if (status == AuditStatus.PASS.getStatus()) {
                if (enrollCourse.getIsRefund() != BizConf.FALSE.intValue()) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u3010" + enrollCourse.getCourseName() + "\u3011\u5df2\u9000\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
                refundRecord.setStatus(AuditStatus.PASS.getStatus());
                refundRecord.setAuditTime(auditRecord.getAuditTime());
                enrollCourse.setIsRefund(BizConf.TRUE.intValue());
                enrollCourse.setIsLock(BizConf.FALSE.intValue());
                enrollCourse.setLockClassId(Long.valueOf(NumberUtils.LONG_ZERO));
                enrollCourse.setUpdateTime(auditRecord.getAuditTime());
                this.enrollCourseDao.update((Object)enrollCourse, new String[]{"isRefund", "updateTime", "isLock", "lockClassId"});
                EnrollRecord record = (EnrollRecord)this.enrollRecordDao.getById((Serializable)refundRecord.getEnrollId(), new String[0]);
                this.doRefund(refundRecord.getStudentId(), refundRecord.getEnrollId(), Sets.newHashSet((Object[])new Long[]{refundRecord.getEnrollCourseId()}), record);
                Student student = (Student)this.studentDao.getById((Serializable)refundRecord.getStudentId(), new String[0]);
                this.sendInternalMsg(auditRecord.getApplyId(), student, auditRecord.getContent(), status);
            } else {
                if (status != AuditStatus.REFUSED.getStatus()) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba1\u6838\u72b6\u6001\u4e0d\u6b63\u786e");
                refundRecord.setAuditTime(new Date());
                refundRecord.setStatus(AuditStatus.REFUSED.getStatus());
            }
            this.enrollRefundRecordDao.update((Object)refundRecord, new String[]{"status", "auditTime"});
            return;
        } else {
            if (auditRecord.getApplyType() != ApplyType.DELAY_FOLLOW_TIME.getType()) return;
            String content = auditRecord.getContent();
            MessageBizType bizType = MessageBizType.ADD_FOLLOW_TIME_AUDIT_SUCC;
            if (status == AuditStatus.PASS.getStatus()) {
                content = "\u5ba1\u6279\u901a\u8fc7\uff01" + content;
            } else if (status == AuditStatus.REFUSED.getStatus()) {
                content = "\u5ba1\u6279\u672a\u901a\u8fc7\uff01" + content;
                bizType = MessageBizType.ADD_FOLLOW_TIME_AUDIT_FAILED;
            }
            this.messageSendService.createNotifyMessage(Lists.newArrayList((Object[])new Long[]{auditRecord.getApplyId()}), content, bizType, bizType.getUrl());
        }
    }

    void sendInternalMsg(Long applyId, Student student, String content, int auditStatus) {
        if (auditStatus == AuditStatus.PASS.getStatus()) {
            content = "\u9000\u8d39\u7533\u8bf7\u901a\u8fc7\uff01" + content;
            HashSet recvIds = Sets.newHashSet((Object[])new Long[]{applyId});
            List finances = this.userCommonService.getUserInfoByTypeName(RoleType.FINANCE.getName());
            if (student.getTmkId() > 0L) {
                recvIds.add(student.getTmkId());
            }
            if (student.getAssistantId() > 0L) {
                recvIds.add(student.getAssistantId());
            }
            if (student.getAdviserId() > 0L) {
                recvIds.add(student.getAdviserId());
            }
            if (CollectionUtils.isNotEmpty((Collection)finances)) {
                Set financeIds = BaseUtils.getPropertiesList((Collection)finances, (String)"id");
                recvIds.addAll(financeIds);
            }
            ArrayList rcvIds = Lists.newArrayList((Iterable)recvIds);
            this.messageSendService.createNotifyMessage(rcvIds, content, MessageBizType.REFUND_APPLY_AUDIT_SUCC, MessageBizType.REFUND_APPLY_AUDIT_SUCC.getUrl());
        } else if (auditStatus == AuditStatus.REFUSED.getStatus()) {
            content = "\u9000\u8d39\u7533\u8bf7\u4e0d\u901a\u8fc7\uff01" + content;
            this.messageSendService.createNotifyMessage(Lists.newArrayList((Object[])new Long[]{applyId}), content, MessageBizType.REFUND_APPLY_AUDIT_FAILED, MessageBizType.REFUND_APPLY_AUDIT_FAILED.getUrl());
        }
    }

    void doRefund(Long studentId, Long enrollId, Collection<Long> courseIds, EnrollRecord record) {
        List enrollCourses = this.enrollCourseDao.searchEnrollCourseByCourseId((Collection)Sets.newHashSet((Object[])new Long[]{enrollId}), courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)enrollCourses)) {
            if (courseIds.size() == enrollCourses.size()) {
                Student student = (Student)this.studentDao.getById((Serializable)studentId, new String[0]);
                School school = (School)this.schoolDao.getById((Serializable)Long.valueOf(student.getSchoolId()), new String[0]);
                BaseLoginUser user = LoginUtil.getCurrentUser();
                ArrayList unconsumLessons = Lists.newArrayList();
                for (EnrollCourse course : enrollCourses) {
                    int isRefund = course.getIsRefund();
                    Long courseId = course.getCourseId();
                    if (isRefund == BizConf.FALSE) {
                        EnrollCourseStatisticsDto info = this.enrollStudentLessonDao.getEnrollEnrollStatistics(enrollId, courseId);
                        unconsumLessons.addAll(info.getUnconsumLessons());
                        continue;
                    }
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u3010" + course.getCourseName() + "\u3011\u5df2\u9000\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c");
                }
                this.refundAfter(enrollId, courseIds, unconsumLessons);
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9000\u8d39\u5f02\u5e38\uff1a\u9884\u8ba1\u9000\u8d39\u3010" + courseIds.size() + "\u3011\u95e8\u8bfe\u7a0b\uff0c\u5b9e\u9645\u53ef\u9000\u3010" + enrollCourses.size() + "\u3011\u95e8\u8bfe\u7a0b");
            }
        }
    }

    void refundAfter(Long enrollId, Collection<Long> courseIds, List<EnrollStudentLesson> lessons) {
        Map[] params = new Map[lessons.size()];
        int index = 0;
        HashMap classCache = Maps.newHashMap();
        for (EnrollStudentLesson lesson : lessons) {
            if (lesson.getClassId() != null && lesson.getClassId() > 0L && lesson.getStatus() != StudentLessonStatus.CONSUM.getStatus()) {
                Long classId = lesson.getClassId();
                if (classCache.containsKey(classId)) {
                    ((List)classCache.get(classId)).add(lesson);
                } else {
                    classCache.put(classId, Lists.newArrayList((Object[])new EnrollStudentLesson[]{lesson}));
                }
            }
            HashMap param = Maps.newHashMap();
            param.put("classCourseDetailId", lesson.getClassCourseDetailId());
            param.put("studentId", lesson.getStudentId());
            params[index] = param;
            ++index;
        }
        this.enrollStudentLessonDao.quitLesson(params);
        this.delLessons(enrollId, courseIds, classCache);
    }

    void delLessons(Long enrollId, Collection<Long> courseIds, Map<Long, List<EnrollStudentLesson>> classCache) {
        List enrollCourses;
        if (!classCache.isEmpty() && CollectionUtils.isNotEmpty((Collection)(enrollCourses = this.enrollCourseDao.getEnrollCourseByEnrollId(enrollId)))) {
            Set enrollCourseIds = BaseUtils.getPropertiesList((Collection)enrollCourses, (String)"courseId");
            if (courseIds.size() == enrollCourseIds.size() && enrollCourseIds.containsAll(courseIds)) {
                for (long classId : classCache.keySet()) {
                    List<EnrollStudentLesson> studentLessons = classCache.get(classId);
                    int studentCount = this.enrollStudentLessonDao.getStudentCountByClassId(Long.valueOf(classId), (Collection)Sets.newHashSet((Object[])new Integer[]{JoinLessonType.NORMAL.getStatus(), JoinLessonType.INSERT.getStatus()}));
                    if (studentCount != NumberUtils.INTEGER_ONE) continue;
                    this.quitAfter(studentLessons);
                }
            }
        }
    }

    void quitAfter(List<EnrollStudentLesson> studentLessons) {
        Set lessonIds;
        List details;
        Set classCourseDetailIds = BaseUtils.getPropertiesList(studentLessons, (String)"classCourseDetailId");
        if (CollectionUtils.isNotEmpty((Collection)classCourseDetailIds) && CollectionUtils.isNotEmpty((Collection)(details = this.classCourseDetailDao.getByIds((Collection)classCourseDetailIds, new String[0]))) && CollectionUtils.isNotEmpty((Collection)(lessonIds = BaseUtils.getPropertiesList((Collection)details, (String)"lessonId")))) {
            this.orgClassLessonDao.delByIds((Collection)lessonIds);
            HashMap delCondition = Maps.newHashMap();
            delCondition.put("lessonId", lessonIds);
            this.orgTeacherLessonDao.delByCondition((Map)delCondition);
            this.classCourseDetailDao.clearRelateFromLesson(details);
            this.orgLessonConflictDao.delByCondition((Map)delCondition);
        }
    }

    EnrollRefundRecord transformToRefundRecor(BaseLoginUser user, Student student, EnrollCourse course, int refundLessons, Long refundMoney, EnrollRecord record, School school) {
        EnrollRefundRecord refundRecord = new EnrollRefundRecord();
        refundRecord.setCourseId(course.getCourseId());
        refundRecord.setCourseName(course.getCourseName());
        refundRecord.setCreateTime(new Date());
        refundRecord.setCreatorId(user.getUserId());
        refundRecord.setCreatorName(user.getUserName());
        refundRecord.setEnrollCourseId(course.getId());
        refundRecord.setEnrollId(course.getEnrollId());
        refundRecord.setRefundLesson(refundLessons);
        refundRecord.setRefundMoney(refundMoney);
        refundRecord.setStudentId(student.getId());
        refundRecord.setSchoolId(school.getId());
        refundRecord.setSchoolName(school.getName());
        refundRecord.setChannelType(record.getChannelType());
        refundRecord.setMobile(student.getMobile());
        refundRecord.setPayType(record.getPayType());
        refundRecord.setStatus(AuditStatus.ONGOING.getStatus());
        return refundRecord;
    }
}

