/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.common.service.impl;

import com.baijia.component.permission.enums.RoleType;
import com.baijia.component.permission.po.Role;
import com.baijia.component.permission.service.RoleService;
import com.baijia.component.permission.service.UserRoleService;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.model.IdAndNameAndHeadImgageDto;
import com.baijia.wedo.common.model.IdAndNameDto;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.common.service.UserCommonService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCommonServiceImpl
implements UserCommonService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RoleService roleService;

    @Override
    public List<User> getSubordinateList(Long userId) {
        if (userId == null || userId <= 0L) {
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.NO_LOGIN);
        }
        Set set = Sets.newHashSet();
        set.add(userId);
        ArrayList list = Lists.newArrayList();
        List subList = Lists.newArrayList();
        do {
            if (!CollectionUtils.isNotEmpty((Collection)(subList = this.userDao.getSubordinateListByIds((Collection)set, null)))) continue;
            list.addAll(subList);
            set = BaseUtils.getPropertiesList((Collection)subList, (String)"id");
        } while (CollectionUtils.isNotEmpty((Collection)subList));
        return list;
    }

    @Override
    public List<IdAndNameDto> getSubordinateInfo(Long userId) {
        List<User> users = this.getSubordinateList(userId);
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(users)) {
            return dtos;
        }
        for (User user : users) {
            IdAndNameDto dto = new IdAndNameDto();
            dto.setId(Long.valueOf(user.getId()));
            dto.setName(user.getName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public boolean isRoleTypeUser(Long userId, String typeName) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)typeName), (Object)"typeName is empty");
        return this.userRoleService.isExtUser(userId.longValue(), typeName);
    }

    @Override
    public List<User> getUsersByRoleType(String typeName, String ... queryProps) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)typeName), (Object)"typeName is empty");
        Set userIds = this.userRoleService.getUsersByExt(typeName);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Lists.newArrayList();
        }
        List users = this.userDao.getUsersByIds((Collection)userIds, queryProps);
        return users;
    }

    @Override
    public List<User> getFuzzByRoleType(String typeName, String name, String ... queryProps) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)typeName), (Object)"typeName is empty");
        Set userIds = this.userRoleService.getUsersByExt(typeName);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return Lists.newArrayList();
        }
        List users = this.userDao.getUsersByIds((Collection)userIds, name, queryProps);
        return users;
    }

    @Override
    public List<IdAndNameDto> getUserInfoByTypeName(String typeName) {
        List<User> users = this.getUsersByRoleType(typeName, "id", "name");
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(users)) {
            return dtos;
        }
        for (User user : users) {
            IdAndNameDto dto = new IdAndNameDto();
            dto.setId(Long.valueOf(user.getId()));
            dto.setName(user.getName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<IdAndNameAndHeadImgageDto> getUserInfoByTypeName(String typeName, String name) {
        List<User> users = this.getFuzzByRoleType(typeName, name, "id", "name");
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(users)) {
            return dtos;
        }
        for (User user : users) {
            IdAndNameAndHeadImgageDto dto = new IdAndNameAndHeadImgageDto();
            dto.setId(Long.valueOf(user.getId()));
            dto.setName(user.getName());
            String pic = user.getPic();
            if (StringUtils.isBlank((CharSequence)pic)) {
                pic = "http://img.gsxservice.com/23337934_kbztpb9x.jpeg";
            }
            dto.setHeadImage(pic);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<IdAndNameDto> getRolInfo() {
        List roles = this.roleService.getAllRoles(new String[]{"id", "name"});
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return dtos;
        }
        for (Role role : roles) {
            if (role.getName().equals(RoleType.SYSTEM.getLabel())) continue;
            IdAndNameDto dto = new IdAndNameDto();
            dto.setId(role.getId());
            dto.setName(role.getName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public boolean checkIfSubordinate(Long superior, Long subordinate) {
        User user;
        if (superior == null || superior <= 0L || subordinate == null || subordinate <= 0L) {
            return false;
        }
        if (superior.longValue() == subordinate.longValue()) {
            return true;
        }
        boolean ret = false;
        while ((user = this.userDao.getNormalUserById(subordinate.longValue())) != null && user.getSuperVisor() != null && user.getSuperVisor() > 0L) {
            if (user.getSuperVisor().longValue() == superior.longValue()) {
                ret = true;
                break;
            }
            subordinate = user.getSuperVisor();
        }
        return ret;
    }

    @Override
    public Set<String> queryUserPermission(Long userId) {
        return this.userRoleService.queryUserPermission(userId);
    }
}

