/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.dal.student.dao.TeachEffectDao;
import com.baijia.wedo.dal.student.po.StudentTeachEffect;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TeachEffectDaoImpl
extends JdbcTemplateDaoSupport<StudentTeachEffect>
implements TeachEffectDao {
    @Override
    public StudentTeachEffect getTeachEffectById(long teachEffectId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)Long.valueOf(teachEffectId));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (StudentTeachEffect)this.uniqueResult(builder);
    }

    @Override
    public List<StudentTeachEffect> getTeachEffectByIds(Collection<Long> teachEffectIds, PageDto page) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(teachEffectIds), (Object)"teachEffectIds is empty");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", teachEffectIds);
        if (page != null) {
            builder.setPage(page);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<StudentTeachEffect> getTeachEffectsByStudent(long studentId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("studentId", (Serializable)Long.valueOf(studentId));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }
}

