/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.common.enums.CommentStatus;
import com.baijia.wedo.dal.student.dao.TeachEffectCommentDao;
import com.baijia.wedo.dal.student.po.StudentTeachEffectComment;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TeachEffectCommentDaoImpl
extends JdbcTemplateDaoSupport<StudentTeachEffectComment>
implements TeachEffectCommentDao {
    @Override
    public List<StudentTeachEffectComment> getCommentByEffectId(long effectId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("effectId", (Serializable)Long.valueOf(effectId));
        builder.ne("status", (Serializable)Integer.valueOf(CommentStatus.DELETED.getStatus()));
        builder.asc("status");
        return this.queryList(builder);
    }

    @Override
    public void deleteCommentByIds(Collection<Long> effectIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(effectIds), (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student_teach_effect_comment set status=:status where teacher_id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("status", CommentStatus.DELETED.getStatus());
        params.put("ids", effectIds);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public List<StudentTeachEffectComment> getCommentByEffectIds(Collection<Long> effectIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("effectId", effectIds);
        builder.ne("status", (Serializable)Integer.valueOf(CommentStatus.DELETED.getStatus()));
        builder.desc("status");
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<StudentTeachEffectComment> getCommentByTeacher(long teacherId, Integer status, Date startTime, Date endTime) {
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0, (Object)"startTime is null");
        Preconditions.checkArgument((endTime != null ? 1 : 0) != 0, (Object)"endTime is null");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("teacherId", (Serializable)Long.valueOf(teacherId));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        } else {
            builder.ne("status", (Serializable)Integer.valueOf(CommentStatus.DELETED.getStatus()));
        }
        builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        builder.desc("status");
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public int getCommentCountByTeacher(long teacherId, int status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("teacherId", (Serializable)Long.valueOf(teacherId));
        builder.eq("status", (Serializable)Integer.valueOf(status));
        builder.count("id");
        Integer unCommentCount = (Integer)this.queryForObject(builder, Integer.class);
        return unCommentCount == null ? NumberUtils.INTEGER_ZERO : unCommentCount;
    }
}

