/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.dal.student.dao.StudentFeedbackDao;
import com.baijia.wedo.dal.student.po.StudentFeedback;
import com.beust.jcommander.internal.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Repository;

@Repository
public class StudentFeedbackDaoImpl
extends JdbcTemplateDaoSupport<StudentFeedback>
implements StudentFeedbackDao {
    @Override
    public List<StudentFeedback> getStudentFeedbackByParams(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (params.get("studentId") != null) {
            builder.eq("studentId", (Serializable)((Long)params.get("studentId")));
        }
        if (params.get("studentIds") != null) {
            builder.in("studentId", (Collection)((Set)params.get("studentIds")));
        }
        if (params.get("learningTaskId") != null) {
            builder.eq("learningTaskId", (Serializable)((Long)params.get("learningTaskId")));
        }
        if (params.get("feedbackDate") != null) {
            builder.eq("feedbackDate", (Serializable)((Date)params.get("feedbackDate")));
        }
        if (params.get("startTime") != null && params.get("endTime") != null) {
            Date startTime = new Date((Long)params.get("startTime"));
            Date endTime = new Date((Long)params.get("endTime"));
            startTime = DateUtil.getStartOfDay((Date)startTime);
            endTime = DateUtil.getEndOfDay((Date)endTime);
            builder.between("feedbackDate", (Comparable)startTime, (Comparable)endTime);
        }
        if (params.get("feedbackType") != null) {
            builder.eq("feedbackType", (Serializable)((Integer)params.get("feedbackType")));
        }
        builder.eq("is_del", (Serializable)BizConf.FALSE);
        builder.setPage(page);
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<StudentFeedback> getStudentFeedback(Long studentId, Date feedbackDate) {
        Map params = Maps.newHashMap();
        params.put("studentId", studentId);
        params.put("feedbackDate", feedbackDate);
        return this.getStudentFeedbackByParams(params, null);
    }
}

