/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.wedo.common.enums.ClueStatus;
import com.baijia.wedo.common.enums.ClueType;
import com.baijia.wedo.common.enums.StudentStatus;
import com.baijia.wedo.common.enums.UserStatus;
import com.baijia.wedo.common.enums.YesOrNoType;
import com.baijia.wedo.dal.student.dao.StudentDao;
import com.baijia.wedo.dal.student.po.Student;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class StudentDaoImpl
extends JdbcTemplateDaoSupport<Student>
implements StudentDao {
    @Override
    public Student getStudentAndClueById(long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)Long.valueOf(id));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Student)this.uniqueResult(builder);
    }

    @Override
    public List<Student> searchStudentByParams(String query, Long schoolId, Integer channelType, Integer status, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"name", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE)})));
        }
        if (schoolId != null && schoolId > 0L) {
            builder.eq("schoolId", (Serializable)schoolId);
        }
        if (channelType != null && channelType > 0) {
            builder.eq("channelType", (Serializable)channelType);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> searchStudentByParams(String query, Long schoolId, Integer channelType, Integer status, long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"name", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE)})));
        }
        if (schoolId != null && schoolId > 0L) {
            builder.eq("schoolId", (Serializable)schoolId);
        }
        if (channelType != null && channelType > 0) {
            builder.eq("channelType", (Serializable)channelType);
        }
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.add(Expressions.or((Expression[])new Expression[]{Expressions.eq((String)"tmkId", (Serializable)Long.valueOf(userId)), Expressions.eq((String)"adviserId", (Serializable)Long.valueOf(userId)), Expressions.eq((String)"creatorId", (Serializable)Long.valueOf(userId)), Expressions.eq((String)"assistantId", (Serializable)Long.valueOf(userId))}));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public Student getStudentById(long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("id", (Serializable)Long.valueOf(id));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Student)this.uniqueResult(builder);
    }

    @Override
    public List<Student> getStudentByIds(Set<Long> ids) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.in("id", ids);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> getStudentAndClueByIds(Set<Long> ids) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentCount() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer totalCount = (Integer)this.queryForObject(builder, Integer.class);
        return totalCount != null ? totalCount : 0;
    }

    @Override
    public List<Student> getAllStudents(PageDto pageDto, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Student> getStudentListParams(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("name")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsName", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("mobile")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsMobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Mobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (params.get("userSchoolIds") == null) {
            if (params.get("userIds") != null) {
                builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"assistantId", (Collection)((Set)params.get("userIds")))}));
            }
        } else if (params.get("userIds") != null) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"assistantId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"schoolId", (Collection)((List)params.get("userSchoolIds")))}));
        }
        if (params.get("browseType") != null) {
            builder.eq("browseType", (Serializable)((Integer)params.get("browseType")));
        }
        if (params.get("assistantId") != null) {
            builder.eq("assistantId", (Serializable)((Long)params.get("assistantId")));
        }
        if (params.get("schoolId") != null) {
            builder.eq("schoolId", (Serializable)((Long)params.get("schoolId")));
        }
        if (params.get("bindWechat") != null) {
            if (((Integer)params.get("bindWechat")).intValue() == YesOrNoType.YES.getType()) {
                builder.add(Expressions.and((Expression)Expressions.isNotNull((String)"weixinOpenId"), (Expression)Expressions.ne((String)"weixinOpenId", (Serializable)((Object)""))));
            } else {
                builder.add(Expressions.or((Expression)Expressions.isNull((String)"weixinOpenId"), (Expression)Expressions.eq((String)"weixinOpenId", (Serializable)((Object)""))));
            }
        }
        if (params.get("canRecommend") != null) {
            builder.eq("canRecommend", (Serializable)((Integer)params.get("canRecommend")));
        }
        if (params.get("hasIntermediary") != null) {
            builder.eq("hasIntermediary", (Serializable)((Integer)params.get("hasIntermediary")));
        }
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.desc("transformTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<Student> getWechatStudentListParams(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("name")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsName", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsMobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Mobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE)})}));
        }
        if (CollectionUtils.isNotEmpty((Collection)((Set)params.get("userIds")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"assistantId", (Collection)((Set)params.get("userIds")))}));
        }
        if (CollectionUtils.isNotEmpty((Collection)((Set)params.get("assistantIds")))) {
            builder.in("assistantId", (Collection)((Set)params.get("assistantIds")));
        }
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public int getStudentCountByIds(Set<Long> ids) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.in("id", ids);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public List<Student> getStudentByMobiles(String mobile, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public void allocationStudentToAdviser(Collection<Long> ids, Long adviserId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((adviserId != null && adviserId != 0L ? 1 : 0) != 0, (Object)"adviserId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set adviser_id=:adviserId, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("adviserId", adviserId);
        params.put("adviserAllocateTime", new Date());
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void allocationStudentToTmk(Collection<Long> ids, Long tmkId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((tmkId != null && tmkId != 0L ? 1 : 0) != 0, (Object)"tmkId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set tmk_id=:tmkId, tmk_allocate_time=:tmkAllocateTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("tmkId", tmkId);
        params.put("tmkAllocateTime", new Date());
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void allocationStudentToAssistant(Collection<Long> ids, Long assistantId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((assistantId != null && assistantId != 0L ? 1 : 0) != 0, (Object)"assistantId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set assistant_id=:assistantId, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("assistantId", assistantId);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void setStudentBrowseType(Collection<Long> ids, int browseType) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set browse_type=:browseType where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("browseType", browseType);
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public List<Student> getfuzzyAllByName(String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        PageDto page = new PageDto();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(page);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public int getStudentCountBySchoolId(Long schoolId, Collection<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("schoolId", (Serializable)schoolId);
        if (CollectionUtils.isNotEmpty(status)) {
            builder.in("status", status);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getAllotTMKStudentCount(Collection<Long> tmkIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tmkIds), (Object)"tmkIds\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("tmkId", tmkIds);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getAllotAssitStudentCount(Collection<Long> assistantIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(assistantIds), (Object)"assistantId\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("assistantId", assistantIds);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getAllotAdviserStudentCount(Collection<Long> adviserIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(adviserIds), (Object)"adviserIds\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("adviserId", adviserIds);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public List<Student> getStudentByName(String query, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.like("name", (Serializable)((Object)query), MatchMode.ANYWHERE);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Student> getStudentByNameOrMobile(String query, Collection<Long> studentIds, Integer clueStatus, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (CollectionUtils.isNotEmpty(studentIds)) {
            builder.in("id", studentIds);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"name", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"mobile", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE)));
        }
        if (clueStatus != null) {
            builder.eq("status", (Serializable)clueStatus);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Student> getValidStudentAndClue(String query, Collection<Long> studentIds, Collection<Integer> clueStatus, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (CollectionUtils.isNotEmpty(studentIds)) {
            builder.in("id", studentIds);
        }
        if (StringUtils.isNotBlank((CharSequence)query)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"name", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"mobile", (Serializable)((Object)query), (MatchMode)MatchMode.ANYWHERE)));
        }
        builder.eq("studentStatus", (Serializable)Integer.valueOf(StudentStatus.NORMARL.getStatus()));
        builder.or(Expressions.and((Expression)Expressions.eq((String)"status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus())), (Expression)Expressions.eq((String)"clueType", (Serializable)Integer.valueOf(ClueType.PRIVATE.getType()))), Expressions.or((Expression[])new Expression[]{Expressions.eq((String)"status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()))}));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Student> getWechatStudentListByMobile(String mobile) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.like("mobile", (Serializable)((Object)mobile), MatchMode.ANYWHERE);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> getWechatStudentByIds(Collection<Long> studentIds, String ... properties) {
        SingleSqlBuilder builder = this.createSqlBuilder(properties);
        builder.in("id", studentIds);
        builder.isNotNull("weixinOpenId");
        builder.eq("studentStatus", (Serializable)Integer.valueOf(StudentStatus.NORMARL.getStatus()));
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> getWechatStudentParentListByMobile(String mobile) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.add(Expressions.or((Expression)Expressions.like((String)"contactsMobile", (Serializable)((Object)mobile), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"contacts2Mobile", (Serializable)((Object)mobile), (MatchMode)MatchMode.ANYWHERE)));
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.STUDENT.getStatus()));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> getMyStudents(Collection<Long> userIds, String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", userIds), Expressions.in((String)"adviserId", userIds), Expressions.in((String)"marketId", userIds), Expressions.in((String)"assistantId", userIds)}));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        return this.queryList(builder);
    }
}

