/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.common.constant.BizConf;
import com.baijia.wedo.dal.student.dao.StudentCommentDao;
import com.baijia.wedo.dal.student.po.StudentComment;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class StudentCommentDaoImpl
extends JdbcTemplateDaoSupport<StudentComment>
implements StudentCommentDao {
    @Override
    public List<StudentComment> getCommentList(Long studentId, Long userId, Integer isMilestone, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProp);
        builder.eq("studentId", (Serializable)studentId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        if (isMilestone != null && isMilestone == 1) {
            builder.eq("isMilestone", (Serializable)BizConf.TRUE);
        }
        if (page != null) {
            builder.setPage(page);
        }
        return this.queryList(builder);
    }

    @Override
    public List<StudentComment> batchQueryLatestComments(Collection<Long> studentIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("studentId");
        builder.max("updateTime", "updateTime");
        builder.in("studentId", studentIds);
        builder.gt("userId", (Serializable)Integer.valueOf(0));
        builder.groupByNames(new String[]{"studentId"});
        return this.queryList(builder);
    }

    @Override
    public void transferCommentsToClue(long sourceClueId, long targetClueId) {
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student_comment set student_id=:targetClueId where student_id=:sourceClueId and is_del=:isDel");
        HashMap params = Maps.newHashMap();
        params.put("sourceClueId", sourceClueId);
        params.put("targetClueId", targetClueId);
        params.put("isDel", DeleteStatus.NORMAL.getValue());
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }
}

