/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.wedo.dal.student.dao.LearningSubtaskDao;
import com.baijia.wedo.dal.student.po.StudentLearningSubtask;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class LearningSubtaskDaoImpl
extends JdbcTemplateDaoSupport<StudentLearningSubtask>
implements LearningSubtaskDao {
    @Override
    public List<StudentLearningSubtask> getByTaskId(Long taskId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("learningTaskId", (Serializable)taskId);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, List<StudentLearningSubtask>> getAndCacheByTaskIds(Collection<Long> taskIds) {
        HashMap subTaskMap = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("learningTaskId", taskIds);
        List learningSubtasks = this.queryList(builder);
        for (StudentLearningSubtask subtask : learningSubtasks) {
            List subTasksOfTask = (List)subTaskMap.get(subtask.getLearningTaskId());
            if (subTasksOfTask == null) {
                subTasksOfTask = Lists.newArrayList();
                subTaskMap.put(subtask.getLearningTaskId(), subTasksOfTask);
            }
            subTasksOfTask.add(subtask);
        }
        return subTaskMap;
    }
}

