/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.student.dao.impl;

import com.baijia.component.permission.enums.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.baijia.wedo.common.enums.ClueStatus;
import com.baijia.wedo.common.enums.ClueType;
import com.baijia.wedo.common.enums.FromTmkStatus;
import com.baijia.wedo.common.enums.OceanClueType;
import com.baijia.wedo.common.enums.UserStatus;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.dal.student.dao.ClueDao;
import com.baijia.wedo.dal.student.po.Student;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class ClueDaoImpl
extends JdbcTemplateDaoSupport<Student>
implements ClueDao {
    @Override
    public List<Student> getClueListParams(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("name")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsName", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("mobile")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsMobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Mobile", (Serializable)((Object)((String)params.get("mobile"))), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (params.get("status") != null && params.get("status") == ClueStatus.TMK) {
            if (params.get("userIds") != null) {
                builder.add(Expressions.or((Expression)Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), (Expression)Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds")))));
            }
        } else if (params.get("userSchoolIds") == null) {
            if (params.get("userIds") != null) {
                builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds")))}));
            }
        } else if (params.get("userIds") != null) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"schoolId", (Collection)((List)params.get("userSchoolIds")))}));
        }
        if (params.get("channelType") != null) {
            builder.eq("channelType", (Serializable)((Integer)params.get("channelType")));
        }
        if (params.get("consultStatus") != null) {
            builder.eq("consultStatus", (Serializable)((Integer)params.get("consultStatus")));
        }
        if (params.get("studyPhase") != null) {
            builder.eq("studyPhase", (Serializable)((Integer)params.get("studyPhase")));
        }
        if (params.get("tmkId") != null) {
            builder.eq("tmkId", (Serializable)((Long)params.get("tmkId")));
        }
        if (params.get("adviserId") != null) {
            builder.eq("adviserId", (Serializable)((Long)params.get("adviserId")));
        }
        if (params.get("schoolId") != null) {
            builder.eq("schoolId", (Serializable)((Long)params.get("schoolId")));
        }
        if (params.get("oceanClueType") != null) {
            builder.eq("oceanClueType", (Serializable)((Integer)params.get("oceanClueType")));
        }
        if (params.get("clueType") != null) {
            builder.eq("clueType", (Serializable)((Integer)params.get("clueType")));
        }
        if (params.get("status") != null) {
            builder.eq("status", (Serializable)((Integer)params.get("status")));
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        if (params.get("marketId") != null) {
            builder.eq("marketId", (Serializable)((Long)params.get("marketId")));
        }
        if (params.get("startTime") != null && params.get("endTime") != null) {
            Date startTime = new Date((Long)params.get("startTime"));
            Date endTime = new Date((Long)params.get("endTime"));
            if (startTime.getTime() == endTime.getTime()) {
                startTime = DateUtil.getStartOfDay((Date)startTime);
            }
            endTime = DateUtil.getEndOfDay((Date)endTime);
            builder.between("createTime", (Comparable)startTime, (Comparable)endTime);
        }
        String descBy = "createTime";
        if (params.get("status") != null && params.get("clueType") != null) {
            if (((Integer)params.get("status")).intValue() == ClueStatus.TMK.getStatus() && ((Integer)params.get("clueType")).intValue() == ClueType.PRIVATE.getType()) {
                descBy = "tmkAllocateTime";
            } else if (((Integer)params.get("status")).intValue() == ClueStatus.CLUE.getStatus() && ((Integer)params.get("clueType")).intValue() == ClueType.PRIVATE.getType()) {
                descBy = "adviserAllocateTime";
            }
        }
        if (params.get("canRecommend") != null) {
            builder.eq("canRecommend", (Serializable)((Integer)params.get("canRecommend")));
        }
        if (params.get("hasIntermediary") != null) {
            builder.eq("hasIntermediary", (Serializable)((Integer)params.get("hasIntermediary")));
        }
        builder.desc(descBy);
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<Student> getPetitionedClueList(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (params.get("tmkIds") != null) {
            builder.in("tmkId", (Collection)((Set)params.get("tmkIds")));
        }
        if (params.get("startTime") != null && params.get("endTime") != null) {
            Date startTime = new Date((Long)params.get("startTime"));
            Date endTime = new Date((Long)params.get("endTime"));
            if (startTime.getTime() == endTime.getTime()) {
                startTime = DateUtil.getStartOfDay((Date)startTime);
            }
            endTime = DateUtil.getEndOfDay((Date)endTime);
            builder.between("petitionTime", (Comparable)startTime, (Comparable)endTime);
        }
        builder.gt("adviserId", (Serializable)Integer.valueOf(0));
        builder.isNotNull("petitionTime");
        builder.desc("petitionTime");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<Student> getWechatClueListParams(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (StringUtils.isNotBlank((CharSequence)((String)params.get("name")))) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsName", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Name", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.or((Expression[])new Expression[]{Expressions.like((String)"mobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contactsMobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"contacts2Mobile", (Serializable)((Object)((String)params.get("name"))), (MatchMode)MatchMode.ANYWHERE)})}));
        }
        if (params.get("status") == ClueStatus.TMK) {
            if (params.get("userIds") != null) {
                builder.add(Expressions.or((Expression)Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), (Expression)Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds")))));
            }
        } else if (params.get("userIds") != null) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"tmkId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"adviserId", (Collection)((Set)params.get("userIds"))), Expressions.in((String)"creatorId", (Collection)((Set)params.get("userIds")))}));
        }
        builder.eq("clueType", (Serializable)((Integer)params.get("clueType")));
        builder.eq("status", (Serializable)((Integer)params.get("status")));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.setPage(page);
        if (((Integer)params.get("status")).intValue() == ClueStatus.TMK.getStatus() && ((Integer)params.get("clueType")).intValue() == ClueType.PRIVATE.getType()) {
            builder.desc("tmkAllocateTime");
        } else if (((Integer)params.get("status")).intValue() == ClueStatus.CLUE.getStatus() && ((Integer)params.get("clueType")).intValue() == ClueType.PRIVATE.getType()) {
            builder.desc("adviserAllocateTime");
        } else {
            builder.desc("createTime");
        }
        return this.queryList(builder);
    }

    @Override
    public Map<String, Integer> getCountByMobiles(Set<String> mobiles) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return null;
        }
        final HashMap params0 = Maps.newHashMap();
        final StringBuffer sql0 = new StringBuffer();
        sql0.append("select mobile as cmobile, count(id) as count  from wedo.student where");
        sql0.append(" mobile in(:mobils ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql0.append(" group by cmobile");
        MapBatchQueryTemplate query = new MapBatchQueryTemplate();
        Map mobileCountMap0 = (Map)query.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params0.put("mobils", querySet);
                Map mobileCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql0.toString(), params0, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("cmobile"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return mobileCountMapTemp;
            }
        });
        final HashMap params1 = Maps.newHashMap();
        final StringBuffer sql1 = new StringBuffer();
        sql1.append("select contacts_mobile as contactsMobile, count(id) as count  from wedo.student where");
        sql1.append(" contacts_mobile in(:mobils ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql1.append(" group by contactsMobile");
        MapBatchQueryTemplate query1 = new MapBatchQueryTemplate();
        Map mobileCountMap1 = (Map)query1.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params1.put("mobils", querySet);
                Map mobileCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql1.toString(), params1, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("contactsMobile"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return mobileCountMapTemp;
            }
        });
        final HashMap params2 = Maps.newHashMap();
        final StringBuffer sql2 = new StringBuffer();
        sql2.append("select contacts2_mobile as contacts2Mobile, count(id) as count  from wedo.student where");
        sql2.append(" contacts2_mobile in(:mobils ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql2.append(" group by contacts2Mobile");
        MapBatchQueryTemplate query2 = new MapBatchQueryTemplate();
        Map mobileCountMap2 = (Map)query2.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params2.put("mobils", querySet);
                Map mobileCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql2.toString(), params2, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("contacts2Mobile"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return mobileCountMapTemp;
            }
        });
        HashMap mobileCountMap = Maps.newHashMap();
        for (String mobile : mobiles) {
            mobileCountMap.put(mobile, 0);
        }
        for (String mobile : mobiles) {
            if (mobileCountMap0.get(mobile) != null) {
                mobileCountMap.put(mobile, (Integer)mobileCountMap.get(mobile) + (Integer)mobileCountMap0.get(mobile));
            }
            if (mobileCountMap1.get(mobile) != null) {
                mobileCountMap.put(mobile, (Integer)mobileCountMap.get(mobile) + (Integer)mobileCountMap1.get(mobile));
            }
            if (mobileCountMap2.get(mobile) == null) continue;
            mobileCountMap.put(mobile, (Integer)mobileCountMap.get(mobile) + (Integer)mobileCountMap2.get(mobile));
        }
        return mobileCountMap;
    }

    @Override
    public Map<String, Integer> getCountByNames(Set<String> names) {
        if (CollectionUtils.isEmpty(names)) {
            return null;
        }
        final HashMap params0 = Maps.newHashMap();
        final StringBuffer sql0 = new StringBuffer();
        sql0.append("select name as cname, count(id) as count from wedo.student where");
        sql0.append(" name in(:names ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql0.append(" group by cname");
        MapBatchQueryTemplate query = new MapBatchQueryTemplate();
        Map nameCountMap0 = (Map)query.batchQuery(names, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params0.put("names", querySet);
                Map nameCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql0.toString(), params0, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("cname"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return nameCountMapTemp;
            }
        });
        final HashMap params1 = Maps.newHashMap();
        final StringBuffer sql1 = new StringBuffer();
        sql1.append("select contacts_name as contactsName, count(id) as count  from wedo.student where");
        sql1.append(" contacts_name in(:names ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql1.append(" group by contactsName");
        MapBatchQueryTemplate query1 = new MapBatchQueryTemplate();
        Map nameCountMap1 = (Map)query1.batchQuery(names, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params1.put("names", querySet);
                Map nameCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql1.toString(), params1, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("contactsName"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return nameCountMapTemp;
            }
        });
        final HashMap params2 = Maps.newHashMap();
        final StringBuffer sql2 = new StringBuffer();
        sql2.append("select contacts2_name as contacts2Name, count(id) as count  from wedo.student where");
        sql2.append(" contacts2_name in(:names ) and is_del=" + DeleteStatus.NORMAL.getValue());
        sql2.append(" group by contacts2Name");
        MapBatchQueryTemplate query2 = new MapBatchQueryTemplate();
        Map nameCountMap2 = (Map)query2.batchQuery(names, (BatchQueryCallback)new BatchQueryCallback<String, Map<String, Integer>>(){

            public Map<String, Integer> doQuery(Collection<String> querySet) {
                params2.put("names", querySet);
                Map nameCountMapTemp = (Map)ClueDaoImpl.this.getNamedJdbcTemplate().query(sql2.toString(), params2, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

                    public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                        HashMap<String, Integer> map = new HashMap<String, Integer>();
                        while (rs.next()) {
                            map.put(rs.getString("contacts2Name"), rs.getInt("count"));
                        }
                        return map;
                    }
                });
                return nameCountMapTemp;
            }
        });
        HashMap nameCountMap = Maps.newHashMap();
        for (String name : names) {
            nameCountMap.put(name, 0);
        }
        for (String name : names) {
            if (nameCountMap0.get(name) != null) {
                nameCountMap.put(name, (Integer)nameCountMap.get(name) + (Integer)nameCountMap0.get(name));
            }
            if (nameCountMap1.get(name) != null) {
                nameCountMap.put(name, (Integer)nameCountMap.get(name) + (Integer)nameCountMap1.get(name));
            }
            if (nameCountMap2.get(name) == null) continue;
            nameCountMap.put(name, (Integer)nameCountMap.get(name) + (Integer)nameCountMap2.get(name));
        }
        return nameCountMap;
    }

    @Override
    public Student getClueById(long id) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("id", (Serializable)Long.valueOf(id));
        builder.in("status", (Collection)Sets.newHashSet((Object[])new Integer[]{ClueStatus.TMK.getStatus(), ClueStatus.CLUE.getStatus()}));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Student)this.uniqueResult(builder);
    }

    @Override
    public List<Student> getfuzzyByName(int clueStatus, int clueType, Integer oceanClueType, String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(clueStatus));
        builder.eq("clueType", (Serializable)Integer.valueOf(clueType));
        if (oceanClueType != null) {
            builder.eq("oceanClueType", (Serializable)oceanClueType);
        }
        builder.like("name", (Serializable)((Object)name));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<Student> getfuzzyByName(String name) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        PageDto page = new PageDto();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.like("name", (Serializable)((Object)name), MatchMode.ANYWHERE);
        }
        builder.in("status", (Collection)Sets.newHashSet((Object[])new Integer[]{ClueStatus.TMK.getStatus(), ClueStatus.CLUE.getStatus()}));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(page);
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<Student> getRepeatCluesByMobiles(Collection<String> mobiles) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"mobile", mobiles), Expressions.in((String)"contactsMobile", mobiles), Expressions.in((String)"contacts2Mobile", mobiles)}));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<Student> getRepeatCluesByNames(Collection<String> names) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.add(Expressions.or((Expression[])new Expression[]{Expressions.in((String)"name", names), Expressions.in((String)"contactsName", names), Expressions.in((String)"contacts2Name", names)}));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public int getClueCountByIds(Collection<Long> ids, Integer clueStatus, Integer clueType) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        if (clueStatus == null) {
            builder.in("status", (Collection)Sets.newHashSet((Object[])new Integer[]{ClueStatus.TMK.getStatus(), ClueStatus.CLUE.getStatus()}));
        } else {
            builder.eq("status", (Serializable)clueStatus);
        }
        if (clueType != null) {
            builder.eq("clueType", (Serializable)clueType);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public List<Student> getNotFollowPrivateClues() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus()));
        builder.eq("clueType", (Serializable)Integer.valueOf(ClueType.PRIVATE.getType()));
        builder.isNull("lastFollowTime");
        builder.isNotNull("adviserAllocateTime");
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<Student> getHasFollowPrivateClues() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus()));
        builder.eq("clueType", (Serializable)Integer.valueOf(ClueType.PRIVATE.getType()));
        builder.isNotNull("lastFollowTime");
        builder.isNotNull("adviserAllocateTime");
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public int getClaimClueCountByIds(Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus()));
        builder.eq("clueType", (Serializable)Integer.valueOf(ClueType.OCEAN.getType()));
        builder.eq("oceanClueType", (Serializable)Integer.valueOf(OceanClueType.CLAIM.getType()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getAllocationClueCountByIds(Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus()));
        builder.eq("clueType", (Serializable)Integer.valueOf(ClueType.OCEAN.getType()));
        builder.eq("oceanClueType", (Serializable)Integer.valueOf(OceanClueType.ALLOCATING.getType()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getReturnToTmkCountByIds(Collection<Long> ids) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("id", ids);
        builder.eq("status", (Serializable)Integer.valueOf(ClueStatus.CLUE.getStatus()));
        builder.eq("clueType", (Serializable)Integer.valueOf(ClueType.PRIVATE.getType()));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public void allocationTmkClue(Collection<Long> ids, Long tmkId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((tmkId != null && tmkId != 0L ? 1 : 0) != 0, (Object)"tmkId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set tmk_id=:tmkId, tmk_allocate_time=:tmkAllocateTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("tmkId", tmkId);
        params.put("tmkAllocateTime", new Date());
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void allocationCCClueToAdviser(Collection<Long> ids, Long adviserId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((adviserId != null && adviserId != 0L ? 1 : 0) != 0, (Object)"adviserId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set adviser_id=:adviserId, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("adviserId", adviserId);
        params.put("adviserAllocateTime", new Date());
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void allocationCCClueToMarket(Collection<Long> ids, Long marketId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((marketId != null && marketId != 0L ? 1 : 0) != 0, (Object)"marketId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set market_id=:marketId, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("marketId", marketId);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void allocationCCClueToTmk(Collection<Long> ids, Long tmkId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((tmkId != null && tmkId != 0L ? 1 : 0) != 0, (Object)"tmkId is null");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set tmk_id=:tmkId, tmk_allocate_time=:tmkAllocateTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("tmkId", tmkId);
        params.put("tmkAllocateTime", new Date());
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void setInvalidClue(Collection<Long> ids, String invalidReason) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, invalid_reason=:invalidReason, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.INVALID.getType());
        params.put("invalidReason", invalidReason);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void setValidTmkClue(Collection<Long> ids, Long userId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((userId != null && userId != 0L ? 1 : 0) != 0, (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, tmk_id=:tmkId, tmk_allocate_time=:tmkAllocateTime, invalid_reason=:invalidReason, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.PRIVATE.getType());
        params.put("invalidReason", null);
        params.put("tmkId", userId);
        params.put("tmkAllocateTime", new Date());
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void setValidCCClueToAdviser(Collection<Long> ids, Long userId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((userId != null && userId != 0L ? 1 : 0) != 0, (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, adviser_id=:adviserId, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, invalid_reason=:invalidReason, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.PRIVATE.getType());
        params.put("invalidReason", null);
        params.put("adviserId", userId);
        params.put("adviserAllocateTime", new Date());
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void setValidCCClueToTmk(Collection<Long> ids, Long userId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((userId != null && userId != 0L ? 1 : 0) != 0, (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, tmk_id=:tmkId, adviser_id=:adviserId, tmk_allocate_time=:tmkAllocateTime, last_follow_time=:lastFollowTime, adviser_allocate_time=:adviserAllocateTime, status=:status, invalid_reason=:invalidReason, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.PRIVATE.getType());
        params.put("status", ClueStatus.TMK.getStatus());
        params.put("tmkId", userId);
        params.put("tmkAllocateTime", new Date());
        params.put("invalidReason", null);
        params.put("adviserId", 0);
        params.put("lastFollowTime", null);
        params.put("adviserAllocateTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void claimCCClueToTmk(Collection<Long> ids, Long tmkId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((tmkId != null && tmkId != 0L ? 1 : 0) != 0, (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, tmk_id=:tmkId, adviser_id=:adviserId, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, status=:status, tmk_allocate_time=:tmkAllocateTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.PRIVATE.getType());
        params.put("status", ClueStatus.TMK.getStatus());
        params.put("tmkId", tmkId);
        params.put("tmkAllocateTime", new Date());
        params.put("adviserId", 0);
        params.put("adviserAllocateTime", null);
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void claimCCClueToAdviser(Collection<Long> ids, Long adviserId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((adviserId != null && adviserId != 0L ? 1 : 0) != 0, (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set clue_type=:clueType, adviser_id=:adviserId, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueType", ClueType.PRIVATE.getType());
        params.put("adviserId", adviserId);
        params.put("adviserAllocateTime", new Date());
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public void returnToTmk(Collection<Long> ids) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        StringBuilder sql = new StringBuilder();
        sql.append("update wedo.student set status=:clueStatus, adviser_id=:adviserId, is_fromtmk=:isFromtmk, adviser_allocate_time=:adviserAllocateTime, last_follow_time=:lastFollowTime, tmk_allocate_time=:tmkAllocateTime, update_time =:updateTime where id in(:ids)");
        HashMap params = Maps.newHashMap();
        params.put("clueStatus", ClueStatus.TMK.getStatus());
        params.put("tmkAllocateTime", new Date());
        params.put("isFromtmk", FromTmkStatus.NO.getValue());
        params.put("adviserId", 0);
        params.put("adviserAllocateTime", null);
        params.put("lastFollowTime", null);
        params.put("updateTime", new Date());
        params.put("ids", ids);
        this.getNamedJdbcTemplate().update(sql.toString(), (Map)params);
    }

    @Override
    public long getClueCountByUserId(long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.add(Expressions.or((Expression[])new Expression[]{Expressions.eq((String)"tmkId", (Serializable)Long.valueOf(userId)), Expressions.eq((String)"adviserId", (Serializable)Long.valueOf(userId)), Expressions.eq((String)"creatorId", (Serializable)Long.valueOf(userId))}));
        builder.in("status", (Collection)Sets.newHashSet((Object[])new Integer[]{ClueStatus.TMK.getStatus(), ClueStatus.CLUE.getStatus()}));
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.count("id");
        Long count = (Long)this.queryForObject(builder, Long.class);
        return count == null ? NumberUtils.LONG_ZERO : count;
    }

    @Override
    public Map<Long, Integer> getAllocateClueCountOfCC(Collection<Long> adviserIds, Long startTime, Long endTime) {
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            Date start = new Date(startTime);
            Date end = new Date(endTime);
            start = DateUtil.getStartOfDay((Date)start);
            end = DateUtil.getEndOfDay((Date)end);
            builder.between("adviserAllocateTime", (Comparable)start, (Comparable)end);
        }
        if (CollectionUtils.isNotEmpty(adviserIds)) {
            builder.in("adviserId", adviserIds);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.group("adviserId");
        builder.count("id");
        List dataList = this.query2ListMap(builder);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (Map data : dataList) {
                Long adviserId = ((Number)data.get("adviserId")).longValue();
                Integer clueCount = ((Number)data.get("CNT_id")).intValue();
                result.put(adviserId, clueCount);
            }
        }
        return result;
    }

    @Override
    public Map<Long, Integer> getAllocateClueCountOfTmk(Collection<Long> tmkIds, Long startTime, Long endTime) {
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            Date start = new Date(startTime);
            Date end = new Date(endTime);
            start = DateUtil.getStartOfDay((Date)start);
            end = DateUtil.getEndOfDay((Date)end);
            builder.between("tmkAllocateTime", (Comparable)start, (Comparable)end);
        }
        if (CollectionUtils.isNotEmpty(tmkIds)) {
            builder.in("tmkId", tmkIds);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.group("tmkId");
        builder.count("id");
        List dataList = this.query2ListMap(builder);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (Map data : dataList) {
                Long tmkId = ((Number)data.get("tmkId")).longValue();
                Integer clueCount = ((Number)data.get("CNT_id")).intValue();
                result.put(tmkId, clueCount);
            }
        }
        return result;
    }

    @Override
    public Map<Long, Integer> getCollectClueCountOfMarket(Collection<Long> marketIds, Long startTime, Long endTime) {
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            Date start = new Date(startTime);
            Date end = new Date(endTime);
            start = DateUtil.getStartOfDay((Date)start);
            end = DateUtil.getEndOfDay((Date)end);
            builder.between("createTime", (Comparable)start, (Comparable)end);
        }
        if (CollectionUtils.isNotEmpty(marketIds)) {
            builder.in("marketId", marketIds);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.group("marketId");
        builder.count("id");
        List dataList = this.query2ListMap(builder);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (Map data : dataList) {
                Long marketId = ((Number)data.get("marketId")).longValue();
                Integer clueCount = ((Number)data.get("CNT_id")).intValue();
                result.put(marketId, clueCount);
            }
        }
        return result;
    }

    @Override
    public Map<Long, Integer> getClueCountOfAssistant(Collection<Long> assistantIds, Long startTime, Long endTime) {
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (startTime != null && endTime != null) {
            Date start = new Date(startTime);
            Date end = new Date(endTime);
            start = DateUtil.getStartOfDay((Date)start);
            end = DateUtil.getEndOfDay((Date)end);
        }
        if (CollectionUtils.isNotEmpty(assistantIds)) {
            builder.in("assistantId", assistantIds);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(UserStatus.NORMAL.getStatus()));
        builder.group("assistantId");
        builder.count("id");
        List dataList = this.query2ListMap(builder);
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            for (Map data : dataList) {
                Long assistantId = ((Number)data.get("assistantId")).longValue();
                Integer clueCount = ((Number)data.get("CNT_id")).intValue();
                result.put(assistantId, clueCount);
            }
        }
        return result;
    }
}

