/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.dal.call.dao.impl;

import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.wedo.common.enums.CallState;
import com.baijia.wedo.common.util.DateUtil;
import com.baijia.wedo.dal.call.dao.StudentCallDao;
import com.baijia.wedo.dal.call.po.StudentCall;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.stereotype.Repository;

@Repository
public class StudentCallDaoImpl
extends JdbcTemplateDaoSupport<StudentCall>
implements StudentCallDao {
    @Override
    public StudentCall getByCallSid(String callSid, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("callSid", (Serializable)((Object)callSid));
        return (StudentCall)this.uniqueResult(builder);
    }

    @Override
    public List<StudentCall> getSyncCallList(PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.isNotNull("callSid");
        builder.eq("needRecord", (Serializable)NumberUtils.INTEGER_ONE);
        builder.or(Expressions.or((Expression[])new Expression[]{Expressions.or((Expression[])new Expression[]{Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.WAIT.getState())), Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.CALLED.getState())), Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.SUCC.getState()))})}), Expressions.and((Expression)Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.COMPLETED.getState())), (Expression)Expressions.eq((String)"isRL", (Serializable)NumberUtils.INTEGER_ONE)));
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public List<StudentCall> getCallList(Map<String, Object> params, PageDto page) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (params.get("userIds") != null) {
            builder.in("creatorId", (Collection)((Set)params.get("userIds")));
        }
        if (params.get("startTime") != null && params.get("endTime") != null) {
            Date startTime = new Date((Long)params.get("startTime"));
            Date endTime = new Date((Long)params.get("endTime"));
            if (startTime.getTime() == endTime.getTime()) {
                startTime = DateUtil.getStartOfDay((Date)startTime);
            }
            endTime = DateUtil.getEndOfDay((Date)endTime);
            builder.between("callTime", (Comparable)startTime, (Comparable)endTime);
        }
        builder.setPage(page);
        builder.desc("callTime");
        return this.queryList(builder);
    }

    @Override
    public int getSyncCallCount() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.isNotNull("callSid");
        builder.eq("needRecord", (Serializable)NumberUtils.INTEGER_ONE);
        builder.or(Expressions.or((Expression[])new Expression[]{Expressions.or((Expression[])new Expression[]{Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.WAIT.getState())), Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.CALLED.getState())), Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.SUCC.getState()))})}), Expressions.and((Expression)Expressions.eq((String)"state", (Serializable)Integer.valueOf(CallState.COMPLETED.getState())), (Expression)Expressions.eq((String)"isRL", (Serializable)NumberUtils.INTEGER_ONE)));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }
}

