package com.baijia.tianxiao.util.encrypt;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Random;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.dto.WsSocket.SocketAuthToken;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.baijia.tianxiao.dto.mobile.TxAuthToken;
import com.baijia.tianxiao.dto.push.PushTokenConfig;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;

public final class EncryptUtils {

    private static final Charset charset = Charset.forName("CP437");

    private static byte[] DEF_KEY = "NP1=~0710*(kZV)M".getBytes();

    private static String DEF_CHARSET = "UTF-8";

    private static int SALT_LENGTH = 8;

    public static String encodeWithAES(String data) throws Exception {
        if (StringUtils.isBlank(data)) {
            return "";
        }
        byte[] dataBytes = data.getBytes(DEF_CHARSET);
        SecretKeySpec skey = new SecretKeySpec(DEF_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.ENCRYPT_MODE, skey);
        byte[] result = cipher.doFinal(dataBytes);
        return Base64.encodeBase64String(result);
    }

    public static String decodeWithAES(String data) throws Exception {
        byte[] dataBytes = Base64.decodeBase64(data);
        SecretKeySpec skey = new SecretKeySpec(DEF_KEY, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(Cipher.DECRYPT_MODE, skey);
        byte[] result = cipher.doFinal(dataBytes);
        return new String(result, DEF_CHARSET);
    }

    /**
     * 解析app登录token
     *
     * @param token
     * @return
     */
    public static String strDecode(String token) {
        String src = base64Decode(token);
        int factor = src.charAt(0);
        int c = factor % 8;
        String entity = src.substring(1);
        List<String> slice = Splitter.fixedLength(factor).splitToList(entity);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); i++) {
            byte[] chars = slice.get(i).getBytes(charset);
            for (int j = 0; j < chars.length; j++) {
                byte ch = chars[j];
                int t = ch - c - i;
                if (t < 0) {
                    t += 256;
                }
                sb.append((char) t);
            }
        }
        return sb.toString();
    }

    public static String base64Decode(String src) {
        if (StringUtils.isBlank(src)) {
            return "";
        } else {
            String deStr = src.replace('-', '+').replace('_', '/');
            return new String(BaseEncoding.base64().decode(deStr), charset);
        }
    }

    /**
     * APP登录生成token
     *
     * @param userId
     * @return token
     */
    public static String strEncode(Integer userId) throws Exception {
        // 步骤一：生成三个属性的json，时间精确到秒
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        AppAuthToken appAuthToken = new AppAuthToken();
        appAuthToken.setCt((int) (System.currentTimeMillis() / 1000));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id(Long.valueOf(userId));
        String str = JacksonUtil.obj2Str(appAuthToken);
        return base64EncodeStrWithFactor(str);
    }

    /**
     * WsSocker长连接生成token
     *
     * @param userId
     * @return token
     */
    public static String wsEncode(String bizType, String userId, Integer deviceDomain) throws Exception {
        // 步骤一：生成三个属性的json，时间精确到秒
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        SocketAuthToken socketAuthToken = new SocketAuthToken();
        socketAuthToken.setCt((int) (System.currentTimeMillis() / 1000));
        socketAuthToken.setSalt(salt);
        socketAuthToken.setUser_id(userId);
        socketAuthToken.setBiz_type(bizType);
        socketAuthToken.setDevice_domain(deviceDomain);
        String str = JacksonUtil.obj2Str(socketAuthToken);
        return base64EncodeStrWithFactor(str);
    }

    /**
     * 长连接推送平台Token生成
     *
     * @return token
     */
    public static String pushTokenEncode(PushTokenConfig authToken) throws Exception {
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        authToken.setCt((int) (System.currentTimeMillis() / 1000));
        authToken.setSalt(salt);
        String str = JacksonUtil.obj2Str(authToken);
        return base64EncodeStrWithFactor(str);
    }

    public static String base64EncodeStrWithFactor(Object obj) {
        return base64EncodeStrWithFactor(JacksonUtil.obj2Str(obj));
    }

    public static String base64EncodeStrWithFactor(String data) {
        // 步骤二：生成加密因子 rand(1,min(255, Math.ceil(len%3));
        Random random = new Random();
        int factor = random.nextInt((int) Math.min(255, Math.ceil(data.length() / 3))) + 1;
        int c = factor % 8;
        // 步骤三：字符换值
        List<String> slice = Splitter.fixedLength(factor).splitToList(data);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); i++) {
            byte[] chars = slice.get(i).getBytes(charset);
            for (int j = 0; j < chars.length; j++) {
                byte ch = chars[j];
                byte t = (byte) (ch + c + i);
                sb.append(new String(new byte[] { t }, charset));
            }
        }
        String token = base64Encode(factor, sb.toString());
        return token;
    }

    /**
     * APP子帐号登录生成token
     *
     * @param userId
     * @return token
     */
    public static String strEncode(Integer userId, Long cascade_user_id, String auth, Integer ts) throws Exception {
        // 步骤一：生成三个属性的json，时间精确到秒
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        AppAuthToken appAuthToken = new AppAuthToken();
        appAuthToken.setCt(ts);
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id(Long.valueOf(userId));
        String str = JacksonUtil.obj2Str(appAuthToken);
        return base64EncodeStrWithFactor(str);
    }

    public static String base64Encode(int factor, String src) {
        if (StringUtils.isBlank(src)) {
            return "";
        } else {
            src = ((char) factor) + src;
            String deStr = BaseEncoding.base64().encode(src.getBytes(charset));
            String result = deStr.replace('+', '-').replace('/', '_');
            while (result.endsWith("=")) {
                result = result.substring(0, result.length() - 1).toString();
            }
            return result;
        }
    }
    /**
     * 天校APP子帐号登录生成token
     *
     * @param userId
     * @return token
     */
    // public static String txStrEncode(Integer userId,Integer tx_cascade_user_id, Integer ts) throws Exception{
    // 步骤一：生成三个属性的json，时间精确到秒
    // String salt = PasswordUtil.randomStr(SALT_LENGTH);
    // AppAuthToken appAuthToken = new AppAuthToken();
    // appAuthToken.setCt(ts);
    // appAuthToken.setSalt(salt);
    // appAuthToken.setUser_id(Long.valueOf(userId));
    // appAuthToken.setTx_cascade_user_id(tx_cascade_user_id);
    // String str = JacksonUtil.obj2Str(appAuthToken);
    // // 步骤二：生成加密因子 rand(1,min(255, Math.ceil(len%3));
    // Random random = new Random();
    // int factor = random.nextInt((int) Math.min(255, Math.ceil(str.length()/3)))+1;
    // int c = factor % 8;
    // // 步骤三：字符换值
    // List<String> slice = Splitter.fixedLength(factor).splitToList(str);
    // StringBuilder sb = new StringBuilder();
    // for (int i = 0; i < slice.size(); i++) {
    // byte[] chars = slice.get(i).getBytes(charset);
    // for (int j = 0; j < chars.length; j++) {
    // byte ch = chars[j];
    // byte t = (byte) (ch + c + i);
    // sb.append(new String(new byte[]{t},charset));
    // }
    // }
    // String token = base64Encode(factor, sb.toString());
    // return token;
    // }

    /**
     * 天校总校区帐号登录生成token + fromOrgId
     *
     * @param userId
     * @return token
     */
    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id,
        Integer fromOrgId, Integer txVisitorId, Integer accountVersion, String appEnv) throws Exception {
        // 步骤一：生成三个属性的json，时间精确到秒
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        TxAuthToken appAuthToken = new TxAuthToken();
        appAuthToken.setCt((int) (System.currentTimeMillis() / 1000));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id(Long.valueOf(userId));
        appAuthToken.setTx_cascade_user_id(tx_cascade_user_id);
        appAuthToken.setTx_account_id(tx_account_id);
        appAuthToken.setTXFrom_org_id(fromOrgId);
        appAuthToken.setAccountVersion(accountVersion);
        appAuthToken.setTx_visitor_id(txVisitorId);
        appAuthToken.setAppEnv(appEnv);
        String str = JacksonUtil.obj2Str(appAuthToken);
        // 步骤二：生成加密因子 rand(1,min(255, Math.ceil(len%3));
        Random random = new Random();
        int factor = random.nextInt((int) Math.min(255, Math.ceil(str.length() / 3))) + 1;
        int c = factor % 8;
        // 步骤三：字符换值
        List<String> slice = Splitter.fixedLength(factor).splitToList(str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); i++) {
            byte[] chars = slice.get(i).getBytes(charset);
            for (int j = 0; j < chars.length; j++) {
                byte ch = chars[j];
                byte t = (byte) (ch + c + i);
                sb.append(new String(new byte[] { t }, charset));
            }
        }
        String token = base64Encode(factor, sb.toString());
        return token;
    }

    /**
     * 天校总校区帐号登录生成token + fromOrgId
     *
     * @param userId
     * @return token
     */
    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id,
        Integer fromOrgId, Integer accountVersion, String appEnv) throws Exception {
        return txStrEncode(userId, tx_cascade_user_id, tx_account_id, fromOrgId, null, accountVersion, appEnv);
    }

    /**
     * 天校总校区帐号登录生成token
     *
     * @param userId
     * @return token
     */
    public static String txStrEncode(Integer userId, Integer tx_cascade_user_id, Integer tx_account_id,
        Integer accountVersion, String appEnv) throws Exception {
        // 步骤一：生成三个属性的json，时间精确到秒
        String salt = PasswordUtil.randomStr(SALT_LENGTH);
        TxAuthToken appAuthToken = new TxAuthToken();
        appAuthToken.setCt((int) (System.currentTimeMillis() / 1000));
        appAuthToken.setSalt(salt);
        appAuthToken.setUser_id(Long.valueOf(userId));
        appAuthToken.setTx_cascade_user_id(tx_cascade_user_id);
        appAuthToken.setTx_account_id(tx_account_id);
        appAuthToken.setAccountVersion(accountVersion);
        appAuthToken.setAppEnv(appEnv);
        // 保持对2.2.0版本之前的app本地支持的auth_token长度的支持,移除此类版本里面返回的auth_token里面的 tx_from_org_id 和 tx_visitor_id
        Map<String, Object> copyToMap = BeanInvokeUtils.transBean2Map(appAuthToken, "tx_from_org_id", "tx_visitor_id");
        String str = JacksonUtil.obj2Str(copyToMap);
        // 步骤二：生成加密因子 rand(1,min(255, Math.ceil(len%3));
        Random random = new Random();
        int factor = random.nextInt((int) Math.min(255, Math.ceil(str.length() / 3))) + 1;
        int c = factor % 8;
        // 步骤三：字符换值
        List<String> slice = Splitter.fixedLength(factor).splitToList(str);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < slice.size(); i++) {
            byte[] chars = slice.get(i).getBytes(charset);
            for (int j = 0; j < chars.length; j++) {
                byte ch = chars[j];
                byte t = (byte) (ch + c + i);
                sb.append(new String(new byte[] { t }, charset));
            }
        }
        String token = base64Encode(factor, sb.toString());
        return token;
    }

    public static void main(String[] args) throws Exception {
        // TxAuthToken appAuthToken = new TxAuthToken();
        // Map<String, Object> copyToMap = BeanInvokeUtils.transBean2Map(appAuthToken, "tx_from_org_id",
        // "tx_visitor_id");
        // String str_ = JacksonUtil.obj2Str(copyToMap);
        // System.out.println("====token is :======" + str_);
        String txStrEncode = txStrEncode(1234, 23, null, 2345, null, null, null);
        System.out.println(txStrEncode.length());
        // String token = "BYAnenhqeGVvaihBOjg4PDQqa3wqQzo9PDpDPUE-PkA3LX5seIAuRi52gYFxRod2fjCL";
        // String str = strDecode(token);
        // System.out.println(str);
        //
        // String token = "BoEoe3lreGZwaylBQDpBPTQqa30rQzo9PTo-Qj1CQz83LX5sd4AuRi5bfYY-XHxVXDCL";
        // String str = strDecode(token);
        // System.out.println(new String(new byte[]{(byte) -121},charset));
        // while(true){
        // System.out.println(JacksonUtil.str2Obj(strDecode(strEncode(13L)),AppAuthToken.class));
        // Thread.sleep(1000L);
        // }
        String token1 = strEncode(52817);
        // String token2 = strEncode(123, 456L, "{1,2,3}", (int) (System.currentTimeMillis() / 1000));
        // System.out.println((token1));
        // System.out.println(strDecode(token1));
        // System.out.println(JacksonUtil.str2Obj(strDecode(token1), AppAuthToken.class));
        // System.out.println((token2));
        // System.out.println(strDecode(token2));
        // System.out.println(JacksonUtil.str2Obj(strDecode(token2), AppAuthToken.class));
        // System.out.println("C34leHZodWJsZyU9NzY3OjAmZ3gmPjU5OTU5Pjk-Nj0xJ3lncnooQCh1O1JYXHhuPSmE");
        // System.out.println(strDecode("C34leHZodWJsZyU9NzY3OjAmZ3gmPjU5OTU5Pjk-Nj0xJ3lncnooQCh1O1JYXHhuPSmE"));
        // System.out.println(JacksonUtil.str2Obj(
        // strDecodePassiveReplyMsgHelper("C34leHZodWJsZyU9NzY3OjAmZ3gmPjU5OTU5Pjk-Nj0xJ3lncnooQCh1O1JYXHhuPSmE"),
        // AppAuthToken.class));
        //
        // System.out.println(strDecode("An0keHZpdmRuaihBODg6QTUsbX8tRj1BQURDQ0FCREY9NIV0f4g2TzddXmppSHBtgTyX"));

        // String token = wsEncode("qr_login", "123", 3);
        // System.out.println(token);
        // System.out.println(JacksonUtil.str2Obj(strDecode(token), SocketAuthToken.class));
        // System.out.print(new Date(2159929870000l));

        PushTokenConfig token = new PushTokenConfig();

        String str = EncryptUtils.pushTokenEncode(token);

        String result = EncryptUtils.txStrEncode(4995, null, null, 0, "test");
        System.out.println(result);
        String result1 = strDecode(
            "D4IpfHpseWZwaylBOUA5PDQqa3wqQnZ9dHQ0KntpdH0rQytiOXh9UGKBdis1K21rfW1rbm9pf31vfGlzbi1FeYB3dzctbIB_cy1FeYF4eDgugIRrb21_b21wcWyCgHJ_bHZxL0dEQ0A5L4KGbW9xcX2DfIJtd3IwSH2Ee3uM");
        System.out.println(result1);
    }
}
