package com.baijia.tianxiao.util;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/7/22
 * Time: 下午3:09
 * To change this template use File | Settings | File Templates.
 */

import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
@Slf4j
public class CookieUtil {

    public static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (int i = 0; i < cookies.length; i++) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(name)) {
                return cookie;
            }
        }
        return null;
    }

    public static void addCookie(HttpServletResponse response, String name, String value, String domain, String path,
                                 int expires) {
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        cookie.setMaxAge(expires);
        response.addCookie(cookie);
        log.debug("addCookie - name:{}, value:{}, domain:{}, path:{}, expires:{}", name, value, domain, path,
                expires);
    }

    public static void deleteCookie(HttpServletRequest request, HttpServletResponse response, String name, String domain) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return;
        }
        for (int i = 0; i < cookies.length; i++) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(name)) {
                cookie.setDomain(domain);
                cookie.setMaxAge(0);
                response.addCookie(cookie);
                return;
            }
        }
    }

}
