
package com.baijia.tianxiao.filter;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;

public class TianxiaoMContext extends AbstractTXWebContext {

    private static final String ORG_ID = "org_id";
    private static final String ORG_CASCADE_ID = "org_cascade_id";
    private static final String ORG_CASCADE_AUTH = "org_cascade_AUTH";
    private static final String ORG_APP_AUTH_TOKEN = "org_app_AUTH_token";
    private static final String TX_CASCADE_ID = "tx_cascade_id";
    private static final String TX_FROM_ORG_ID = "from_org_id";
    private static final String TX_VISITOR_ID = "tx_visitor_id";
    private static final String TX_LOGIN_ACCOUNT_ID = "tx_login_account_id";

    @Override
    protected void init() {
        // nothing to do
    }

    public static void setOrgId(Integer orgId) {
        set(ORG_ID, orgId);
    }

    public static Integer getOrgId() {
        return get(ORG_ID, Integer.class);
    }

    public static void setOrgCascadeId(Long orgCascadeId) {
        set(ORG_CASCADE_ID, orgCascadeId);
    }

    /**
     * 子帐号登录时才有值，主帐号登录时为空
     * 
     * @return
     */
    public static Long getOrgCascadeId() {
        return get(ORG_CASCADE_ID, Long.class);
    }

    public static void setOrgCascadeAuth(String orgCascadeAuth) {
        set(ORG_CASCADE_AUTH, orgCascadeAuth);
    }

    /**
     * 子帐号登录时才有值，主帐号登录时为空 权限信息为数组，如 '1,2,3'，以','分隔
     * 
     * @return
     */
    public static String getOrgCascadeAuth() {
        return get(ORG_CASCADE_AUTH, String.class);
    }

    /**
     * 解析App传入token为对象
     * 
     * @return
     */
    public static AppAuthToken getAppAuthToken() {
        return get(ORG_APP_AUTH_TOKEN, AppAuthToken.class);
    }

    public static void setAppAuthToken(AppAuthToken obj) {
        set(ORG_APP_AUTH_TOKEN, obj);
    }

    /**
     * 解析App传入token为对象
     * 
     * @return
     */
    public static Integer getTXCascadeId() {
        return get(TX_CASCADE_ID, Integer.class);
    }

    /**
     * @Description :
     * @Author : zhenyujian
     * @Date : 2016年12月10日 下午2:38:04
     *
     * @Return : Long
     */
    public static Long getTXCascadeIdLong() {
        Integer obj = getTXCascadeId();
        if (obj != null) {
            return obj.longValue();
        }
        return null;
    }

    /**
     * @Description :
     * @Author : zhenyujian
     * @Date : 2016年12月10日 下午2:38:02
     *
     * @Return : Long
     */
    public static Long getTXCascadeIdLongZeroFill() {
        Integer obj = getTXCascadeId();
        if (obj != null) {
            return obj.longValue();
        }
        return 0L;
    }

    public static void setTXCascadeId(Integer cascadeId) {
        set(TX_CASCADE_ID, cascadeId);
    }

    /**
     * 天校登录帐号id，其余皆为数据帐号相关
     * 
     * @return
     */
    public static Integer getTXLoginAccountId() {
        return get(TX_LOGIN_ACCOUNT_ID, Integer.class);
    }

    public static void setTXLoginAccountId(Integer cascadeId) {
        set(TX_LOGIN_ACCOUNT_ID, cascadeId);
    }

    public static void setTXFromOrgId(Integer fromOrgId) {
        set(TX_FROM_ORG_ID, fromOrgId);
    }

    public static Integer getTXFromOrgId() {
        return get(TX_FROM_ORG_ID, Integer.class);
    }

    public static void setTXVisitorId(Integer txVisitorId) {
        set(TX_VISITOR_ID, txVisitorId);
    }

    public static Integer getTXVisitorId() {
        return get(TX_VISITOR_ID, Integer.class);
    }

}
