/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.smstoken;


import java.util.Map;

import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.CourseSmsTokenUtil.SmsToken;

import lombok.Data;

/**   
 * @title       : WechatSmsTokenDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年9月1日 下午7:58:36 
 */
@Data
public class WechatSmsTokenDto extends SmsTokenDto{
	 private Long orgId;
	 private String wechatAppId;
	 
	
	 private WechatSmsTokenDto (){
	 }
	
	 public WechatSmsTokenDto(Long orgId, String wechatAppId){
		 this.orgId = orgId;
		 this.wechatAppId = wechatAppId;
	 }


	public static WechatSmsTokenDto fromTokenStr(String tokenStr) throws Exception {
		WechatSmsTokenDto obj = new WechatSmsTokenDto();
		SmsToken token = CourseSmsTokenUtil.decodeToken(tokenStr);
		Map<String, Object> map = token.getParams();
		
		obj.setOrgId( map.get("orgId")!=null ? Long.parseLong(map.get("orgId").toString()) : null );
		obj.setWechatAppId( map.get("wechatAppId")!=null ? map.get("wechatAppId").toString() : null );
		
		return obj;
	}
}

