/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.smstoken;


import java.util.Map;

import com.baijia.tianxiao.util.CourseSmsTokenUtil;
import com.baijia.tianxiao.util.CourseSmsTokenUtil.SmsToken;

import lombok.Data;

/**   
 * @title       : WechatSmsTokenDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年9月1日 下午7:58:36 
 */
@Data
public class StudentSmsTokenDto extends SmsTokenDto{
	 private Long orgId;
	 private String wechatAppId;
	 private Long studentId;
	 private String openId;
	
	 private StudentSmsTokenDto (){
	 }
	
	 public StudentSmsTokenDto(Long orgId, String wechatAppId, Long studentId, String openId){
		 this.orgId = orgId;
		 this.wechatAppId = wechatAppId;
		 this.studentId = studentId;
		 this.openId = openId;
	 }

	public static StudentSmsTokenDto fromTokenStr(String tokenStr) throws Exception {
		StudentSmsTokenDto obj = new StudentSmsTokenDto();
		SmsToken token = CourseSmsTokenUtil.decodeToken(tokenStr);
		Map<String, Object> map = token.getParams();
		
		obj.setOrgId( map.get("orgId")!=null ? Long.parseLong(map.get("orgId").toString()) : null );
		obj.setWechatAppId( map.get("wechatAppId")!=null ? map.get("wechatAppId").toString() : null );
		obj.setStudentId( map.get("studentId")!=null ? Long.parseLong(map.get("studentId").toString()) : null );
		obj.setOpenId( map.get("openId")!=null ? map.get("openId").toString() : null );
		
		return obj;
	}
	
	public static void main(String args[]) throws Exception{
		String a ="NoEoenkoQDc6Pjc_Pjw4Nzk2OzcyKHV4bU9qKEA6PDw5NzIodmd4Z3N5KECBKHl6e2prdHpPailBdXxzczMpdndsdVBrKUEpdmo6PHZ_Sj9se2ZmaUl1XF1ceEpQWWpXfXQ-VCkzKXZ5blBrKUI8Pj47OTQqf21rcGl8SXh4UWwqQip_gGtuQG0-amtqOT46aUA-aT8qhTQqfm16e3F3dipCOYY";
//		String a1="LH8meHcmPjU4OzY9Ozs2Nzc6OjUwJnN2a01oJj43OjU8MCZ0ZXZlcXcmPn8mdHdsTmknPzg7Nj0xJ3xqaG1meUZ1dU5pJz8nfH01ZzhqPjY-OzdrPDk2ODc2KDIoeXp7amt0ek9qKEA5Oz83NzsyKHV2a3RPaihAKHU2a3RufHOAcX9PXlVPZmw4dVNzbXVuPmpIfX4phDMpfWx5enB2dSlBOIQ?sms_token=E34ld3YlPTQ3OjU8Ojo1NjMzOTYwJnN2a01oJj43OjU8MCZ0ZXZlcngnP4AndHdsTmknPzg7Nj0xJ31raW5nekd2dk9qKEAofX42aDlsQDhAPTltPjs4Ojk3KYQzKX1sentxd3YqQjmF";
//		StudentSmsTokenDto dto = new StudentSmsTokenDto(12345L, "hsfjkshfkjhskhfkhsjdfswq", 222L, "hsfjkshfkjhskhfkhsjdfswq");
//		System.out.println(dto.toTokenStr());
		System.out.println(CourseSmsTokenUtil.decodeToken(a));
	}
}

