package com.baijia.tianxiao.constants.signup;

import lombok.Getter;

/**
 * 主站支付方式
 * Created by wangsixia on 2017/1/17.
 */
public enum GsxPayType {

    BALANCE_PAY(1, "balancepay", "余额支付"),
    WEIXIN_APP_PAY(2, "weixinapppay", "微信app支付"),
    WEIXIN_JS_PAY(3, "weixinjspay", "微信app支付"),
    WEIXIN_QR_PAY(4, "weixinqrpay", "微信二维码支付"),
    ALI_APP_PAY(5, "aliapppay", "支付宝app支付"),
    ALI_PC_PAY(6, "alipcpay", "支付宝PC支付"),
    ALI_M_PAY(7, "alimpay", "支付宝M站支付"),
    ALI_QR_PAY(8, "aliqrpay", "支付宝二维码支付"),
//    UNION_APP_PAY(9, "unionapppay", "银联支付"),//支付已下掉
    BILL_POS_PAY(10, "billpospay", "快银POS支付"),
    BANK_PAY(11, "bankpay", "银行卡快捷支付"),
    HUA_BEI_PAY(12, "huabeipay", "花呗支付"),
    ;

    @Getter
    private int code;
    @Getter
    private String type;
    @Getter
    private String desc;

    private GsxPayType(int code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }
}
