package com.baijia.tianxiao.constants;

import java.util.Map;

import com.google.common.collect.Maps;

public enum PayStatus {
    PROCESSING(0, "交易中"), SUCESS(1, "交易完成"), FAILED(2, "交易失败"), CANCLE(3, "交易取消"), OVERTIME(4, "过期未支付"), CANCLEAFTERPAY(
        5, "支付后取消");

    private int code;

    private String note;

    private static Map<Integer, PayStatus> map = Maps.newHashMap();

    private PayStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (PayStatus signupStatus : PayStatus.values()) {
            map.put(signupStatus.code, signupStatus);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static PayStatus getPayTypeByCode(Integer code) {
        return map.get(code);
    }
}
