/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.http.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortUrlUtil {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlUtil.class);

    public static String getShortUrl(String longUrl) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{longUrl}), (Object)"long url is empty");
        try {
            String url = UrlProperties.getProperty("shorturl.api");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("long_url", longUrl);
            log.info("transfer long url:{} into short url.", (Object)longUrl);
            String response = HttpClientUtils.doGet((String)url, params);
            Map responseMap = JacksonUtil.str2Obj(response, Map.class);
            if (responseMap.containsKey("data")) {
                Map dataMap = (Map)responseMap.get("data");
                return (String)dataMap.get("short_url");
            }
        }
        catch (Exception e) {
            log.error("get short url catch error:{} and will return origin url ", (Throwable)e);
        }
        return longUrl;
    }
}

