/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.aliyun.mns.client.CloudAccount;
import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.client.MNSClient;
import com.aliyun.mns.model.Message;
import com.aliyun.mns.model.QueueMeta;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqsUtils {
    private static final Logger logger = LoggerFactory.getLogger(MqsUtils.class);
    private static final int POLLING_WAIT_SECONDS = 15;
    private static final long MAX_MSG_SIZE = 2048L;
    private MNSClient client;

    public MqsUtils() {
        CloudAccount account = new CloudAccount(PropertiesReader.getValue("mns", "mns.accesskeyid"), PropertiesReader.getValue("mns", "mns.accesskeysecret"), PropertiesReader.getValue("mns", "mns.accountendpoint"));
        this.client = account.getMNSClient();
    }

    public CloudQueue getAndCreateQueue(String queueName) {
        CloudQueue queue = this.client.getQueueRef(queueName);
        if (queue == null) {
            QueueMeta meta = new QueueMeta();
            meta.setQueueName(queueName);
            meta.setPollingWaitSeconds(Integer.valueOf(15));
            meta.setMaxMessageSize(Long.valueOf(2048L));
            queue = this.client.createQueue(meta);
        }
        return queue;
    }

    public void sendMessage(String queueName, String messageBody) {
        CloudQueue queue = this.getAndCreateQueue(queueName);
        String msgId = UUID.randomUUID().toString();
        Message message = new Message();
        message.setMessageBody(messageBody);
        message.setRequestId(msgId);
        logger.info("sendMessage.queueName:{}, messageBody:{}", (Object)queueName, (Object)messageBody);
        queue.putMessage(message);
    }

    public void doAfter() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public MNSClient getClient() {
        return this.client;
    }

    public void setClient(MNSClient client) {
        this.client = client;
    }
}

