/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.image;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class OrgQrImageUtils {
    private static final int DEFAULT_IMAGE_WIDTH = 880;
    private static final int DEFAULT_IMAGE_HEIGHT = 320;
    private static final String ORG_400_HOTLINE = "4000-122-166";
    private static final String IMG_HOTLINE_FORMAT = "%s \u8f6c %s";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromUrl(String url) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)"image url can not be null");
        URL imageUrl = new URL(url);
        InputStream in = null;
        try {
            in = imageUrl.openStream();
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static Image readImageFromFile(String fileName) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}), (Object)"image file name can not be null");
        File imgFile = new File(fileName);
        if (!imgFile.exists()) {
            throw new FileNotFoundException(fileName + " is not exist");
        }
        return ImageIO.read(imgFile);
    }

    public static Image loadImage(String fileName) throws IOException {
        BufferedImage bufferedImage;
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName}), (Object)"image file name can not be null");
        InputStream in = null;
        try {
            in = OrgQrImageUtils.class.getClassLoader().getResourceAsStream(fileName);
            Preconditions.checkNotNull((Object)in, (Object)("can not read file:" + fileName));
            bufferedImage = ImageIO.read(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bufferedImage;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = OrgQrImageUtils.generateOrgQrFingerPrintImg("\u673a\u6784\u540d\u79f0", "http://test-img.gsxservice.com/429623_wvy1l1ie.jpg", "3888888", "weixin");
        File file = new File("/Users/cxm/Downloads/image.jpg");
        ImageIO.write((RenderedImage)img, "png", file);
    }

    public static BufferedImage generateOrgQrFingerPrintImg(String orgName, String qrUrl, String extension, String weixin) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgName}), (Object)"orgName can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{qrUrl}), (Object)"qrUrl can not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weixin}), (Object)"weixin can not be null");
        String telStr = "";
        if (extension != null) {
            telStr = String.format(IMG_HOTLINE_FORMAT, ORG_400_HOTLINE, extension);
        }
        String weixinStr = "\u5fae\u4fe1\u53f7: " + weixin;
        Image qrImg = OrgQrImageUtils.getImageFromUrl(qrUrl);
        Image telImg = OrgQrImageUtils.loadImage("img/phone_icon.png");
        Image fpImg = OrgQrImageUtils.loadImage("img/zhiwen.png");
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 25);
        BufferedImage bi = new BufferedImage(880, 320, 8);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2.setBackground(Color.WHITE);
        g2.fillRect(0, 0, 880, 320);
        g2.drawImage(qrImg, 72, 20, 280, 280, null);
        g2.setPaint(Color.BLACK);
        g2.setFont(font);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(telStr, context);
        double x = 402.0;
        double y = 106.0;
        double ascent = -bounds.getY();
        double baseY = y + ascent;
        g2.drawImage(telImg, (int)x, (int)baseY / 2 + 77, 30, 30, null);
        g2.drawString(telStr, (int)x + 40, (int)baseY / 2 + 100);
        Font nameFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 23);
        g2.drawString(orgName, (int)x, (int)baseY / 2);
        g2.setFont(nameFont);
        g2.setColor(Color.gray);
        g2.drawString(weixinStr, (int)x, (int)baseY / 2 + 50);
        g2.drawImage(fpImg, (int)x, 220, 390, 60, null);
        return bi;
    }
}

