/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.rest;

import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.dto.signup.CreatePurchaseResponseDto;
import com.baijia.tianxiao.dto.signup.CreateTradePurchaseResponseDto;
import com.baijia.tianxiao.dto.signup.PayResponseDto;
import com.baijia.tianxiao.dto.signup.PayResultDto;
import com.baijia.tianxiao.dto.signup.PayResultMapResponseDto;
import com.baijia.tianxiao.dto.signup.PurchaseType;
import com.baijia.tianxiao.dto.signup.QueryTradeNoDataDto;
import com.baijia.tianxiao.dto.signup.QueryTradeNoMapResponseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SignupErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.UrlProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtils {
    private static final Logger logger = LoggerFactory.getLogger(RestUtils.class);
    private static final String SPLIT = ":";
    private static final String PAY_WINXIN = "35";
    private static final String URL_SPLIT = "/";
    private static final String SIGN_SPLIT = "-";
    private static final String DEF_CHARSET = "UTF-8";
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final byte[] LOGIN_LOCK = new byte[0];
    private static final long EXPIRE_TIME = 604800000L;
    private String appId;
    private String appKey;
    private String baseUrl;
    public static volatile String authToken = null;
    public static volatile long loginTime = -1L;

    public RestUtils(String appId, String appKey, String baseUrl) {
        this.appId = appId;
        this.appKey = appKey;
        this.baseUrl = baseUrl;
    }

    public <T> RestfulResult<T> rest(RestMethod restMethod, String controller, String action, List<String> urlVarList, Map<String, String> params, T dataType) throws Exception {
        StringBuilder loginUrl = new StringBuilder();
        loginUrl.append(this.baseUrl);
        loginUrl.append(controller);
        loginUrl.append(URL_SPLIT).append(action);
        String signData = RestUtils.createSignData(restMethod.toString(), controller, action, urlVarList, params);
        logger.info("signData=" + signData);
        String sign = RestUtils.getSignature(signData.getBytes(DEF_CHARSET), this.appKey.getBytes(DEF_CHARSET));
        params.put("sign", sign);
        String resultJson = null;
        switch (restMethod) {
            case POST: {
                resultJson = HttpClientUtils.doPost(loginUrl.toString(), params, DEF_CHARSET);
                logger.info("login url=" + loginUrl);
                logger.info("param=" + params);
                break;
            }
            case GET: {
                resultJson = HttpClientUtils.doGet(loginUrl.toString(), params, DEF_CHARSET);
                break;
            }
            default: {
                throw new Exception("\u4e0d\u652f\u6301\u7684REST\u65b9\u6cd5");
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        logger.trace(resultJson);
        RestfulResult result = (RestfulResult)mapper.readValue(resultJson, RestfulResult.class);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAuthToken() throws Exception {
        byte[] byArray = LOGIN_LOCK;
        synchronized (LOGIN_LOCK) {
            if (loginTime - System.currentTimeMillis() < 604800000L && authToken != null) {
                // ** MonitorExit[byArray] (shouldn't be in output)
                return authToken;
            }
            String result = null;
            try {
                String controller = "auth";
                String action = "login";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("app_id", this.appId);
                params.put("app_key", this.appKey);
                params.put("timestamp", String.valueOf(System.currentTimeMillis()));
                Object dataType = null;
                RestfulResult<Object> loginResult = this.rest(RestMethod.POST, controller, action, null, params, dataType);
                if (loginResult == null) {
                    String string = null;
                    // ** MonitorExit[byArray] (shouldn't be in output)
                    return string;
                }
                if (loginResult.getCode() != 0) {
                    throw new Exception(loginResult.getMsg());
                }
                String string = result = ((Map)loginResult.getData()).get("auth_token").toString();
                // ** MonitorExit[byArray] (shouldn't be in output)
                return string;
            }
            finally {
                loginTime = System.currentTimeMillis();
                authToken = result;
            }
        }
    }

    public static String createSignData(String restMethod, String controllerName, String actionName, List<String> urlVarList, Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        signData.append(restMethod.toLowerCase());
        signData.append(SIGN_SPLIT).append(controllerName);
        signData.append(SIGN_SPLIT).append(actionName);
        if (urlVarList != null && !urlVarList.isEmpty()) {
            for (String urlVar : urlVarList) {
                if (urlVar == null) {
                    signData.append(SIGN_SPLIT).append("");
                    continue;
                }
                signData.append(SIGN_SPLIT).append(urlVar);
            }
        }
        if (params != null && !params.isEmpty()) {
            String[] paraNames = new String[params.size()];
            Arrays.sort(params.keySet().toArray(paraNames));
            for (String paraName : paraNames) {
                String value = params.get(paraName);
                if (value == null) {
                    value = "";
                }
                signData.append(SIGN_SPLIT).append(value);
            }
        }
        return signData.toString();
    }

    public static String getSignature(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return Base64.encodeBase64String((byte[])rawHmac);
    }

    public static String randomPwd(int len) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[len];
        random.nextBytes(salt);
        char[] saltChars = new char[len];
        int letterPoolSize = TianXiaoConstant.LETTER_POOL.length;
        int numberPoolSize = TianXiaoConstant.NUM_POOL.length;
        for (int i = 0; i < len; ++i) {
            saltChars[i] = i == 0 ? TianXiaoConstant.LETTER_POOL[(salt[i] + 128) % letterPoolSize] : TianXiaoConstant.NUM_POOL[(salt[i] + 128) % numberPoolSize];
        }
        return new String(saltChars);
    }

    public static RestfulResult<Map<String, Object>> createStudent(String mobile, String password, String email, String name, String invite_code) throws Exception {
        String controller = "student";
        String action = "create";
        if (StringUtils.isBlank((String)password)) {
            password = RestUtils.randomPwd(6);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("mobile:" + mobile + ",password:" + password + ",email:" + email + ",name:" + name + ",invite_code:" + invite_code);
        }
        RestfulResult<Map<String, Object>> createResult = null;
        if (StringUtils.isBlank((String)mobile) || StringUtils.isBlank((String)password)) {
            createResult = new RestfulResult<Map<String, Object>>();
            createResult.setCode(1);
            createResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return createResult;
        }
        if (email == null) {
            email = "";
        }
        if (name == null) {
            name = "";
        }
        if (invite_code == null) {
            invite_code = "";
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", mobile);
        params.put("password", password);
        params.put("email", email);
        params.put("realname", name);
        params.put("invite_code", invite_code);
        createResult = GSXService.doService(controller, action, params);
        logger.info("create student return:{}", createResult);
        if (createResult.getCode() == 100050) {
            RestUtils.addRole(mobile, null, UserRoleEnum.STUDENT.getCode(), invite_code);
        }
        return createResult;
    }

    public static RestfulResult<Map<String, Object>> addRole(String mobile, Long orgId, Integer target_role, String invite_code) throws Exception {
        logger.trace("mobile:" + mobile + ",target_role" + target_role);
        RestfulResult<Map<String, Object>> addResult = null;
        if (StringUtils.isBlank((String)mobile) || target_role != 0 && target_role != 2) {
            addResult = new RestfulResult<Map<String, Object>>();
            addResult.setCode(1);
            addResult.setMsg("\u53c2\u6570\u4e0d\u5b8c\u6574");
            return addResult;
        }
        String controller = "user";
        String action = "addRole";
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("mobile", mobile);
        params.put("target_role", target_role.toString());
        params.put("invite_code", invite_code);
        if (orgId != null) {
            params.put("org_id", orgId.toString());
        }
        addResult = GSXService.doService(controller, action, params);
        logger.info("ResUtils.addRole   params:{}, addResult:{}", params, addResult);
        return addResult;
    }

    public static String getWeiXinPurchaseUrl(@NonNull Long purchaseId, @NonNull Long orgId, @NonNull Double totalPrice, Collection<Header> headers) throws BussinessException {
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (totalPrice == null) {
            throw new NullPointerException("totalPrice");
        }
        Preconditions.checkArgument((totalPrice > 0.0 ? 1 : 0) != 0, (Object)"price must great than 0");
        Preconditions.checkArgument((orgId > 0L ? 1 : 0) != 0, (Object)"org id can not be null");
        String url = null;
        if (totalPrice < 0.0) {
            logger.warn("\u5237\u5361\u91d1\u989d\u9519\u8bef\uff1atotalPrice = {}", (Object)totalPrice);
            return null;
        }
        HashMap params = Maps.newHashMap();
        params.put("purchase_id", purchaseId.toString());
        params.put("user_id", orgId.toString());
        params.put("pay_type", "35:" + totalPrice);
        String weixinJson = HttpClientUtils.doPost(UrlProperties.getProperty("pay.getWeixinUrl.url"), params, DEF_CHARSET, headers);
        logger.info("=========weixinJson={}", (Object)weixinJson);
        if (StringUtils.isNotBlank((String)weixinJson)) {
            try {
                CreatePurchaseResponseDto weixinRes = JacksonUtil.str2Obj(weixinJson, CreatePurchaseResponseDto.class);
                if (weixinRes.getCode() == 0) {
                    url = weixinRes.getData().getPayUrl();
                }
            }
            catch (Exception e) {
                logger.info("trans weixinPurchaseRes error!", (Throwable)e);
            }
        }
        return url;
    }

    public static String getWeiXinPurchaseUrl(@NonNull Long orgId, @NonNull Double totalPrice, Collection<Header> headers, CreatePurchaseResponseDto createPurchaseResponseDto) throws BussinessException {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (totalPrice == null) {
            throw new NullPointerException("totalPrice");
        }
        Preconditions.checkArgument((totalPrice > 0.0 ? 1 : 0) != 0, (Object)"price must great than 0");
        Preconditions.checkArgument((orgId > 0L ? 1 : 0) != 0, (Object)"org id can not be null");
        if (totalPrice < 0.0) {
            logger.warn("\u5237\u5361\u91d1\u989d\u9519\u8bef\uff1atotalPrice = {}", (Object)totalPrice);
            return null;
        }
        return RestUtils.getWeiXinPurchaseUrl(createPurchaseResponseDto.getData().getPurchaseId(), orgId, totalPrice, headers);
    }

    public static Long getPurchaseId(@NonNull Long orgId, @NonNull Double totalPrice, Collection<Header> headers) throws BussinessException {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (totalPrice == null) {
            throw new NullPointerException("totalPrice");
        }
        return RestUtils.createPurchaseResponseDto(orgId, totalPrice, headers).getData().getPurchaseId();
    }

    public static CreatePurchaseResponseDto createPurchaseResponseDto(@NonNull Long orgId, @NonNull Double totalPrice, Collection<Header> headers) throws BussinessException {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (totalPrice == null) {
            throw new NullPointerException("totalPrice");
        }
        Preconditions.checkArgument((orgId > 0L ? 1 : 0) != 0, (Object)"org id can not be null");
        Preconditions.checkArgument((totalPrice >= 0.0 ? 1 : 0) != 0, (Object)"price must great than 0");
        String response = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("org_id", orgId.toString());
            params.put("total_prices", totalPrice.toString());
            String url = UrlProperties.getProperty("pay.createpurchase.url");
            logger.info("create purchase by params:{},url:{}", params, (Object)url);
            response = HttpClientUtils.doPost(url, params, DEF_CHARSET, headers);
            logger.info("create purchase-->response {}", (Object)response);
        }
        catch (Exception e) {
            logger.warn("create purchase get error:{}", (Throwable)e);
            throw new BussinessException(SignupErrorCode.SPLITPURCHASE_ERROR);
        }
        CreatePurchaseResponseDto dto = RestUtils.checkPayResponse(response, CreatePurchaseResponseDto.class);
        Preconditions.checkNotNull((Object)dto.getData().getPurchaseId(), (Object)("can not get purchase id from response:" + response));
        return dto;
    }

    private static <T extends PayResponseDto> T checkPayResponse(String response, Class<T> type) throws BussinessException {
        PayResponseDto splitSignupPurchaseResponseDto = null;
        if (StringUtils.isNotEmpty((String)response)) {
            try {
                splitSignupPurchaseResponseDto = (PayResponseDto)JacksonUtil.str2Obj(response, type);
            }
            catch (Exception e) {
                logger.error("parse result:{} to object get error:{}", (Object)response, (Object)e);
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
            }
            if (splitSignupPurchaseResponseDto != null && splitSignupPurchaseResponseDto.getCode() != 0) {
                String message = "";
                try {
                    message = new String(splitSignupPurchaseResponseDto.getMsg().getBytes(DEF_CHARSET), DEF_CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
                if (!message.startsWith("\u5f53\u524d\u673a\u6784\u6536\u8d39\u8ba2\u5355\u5df2\u5206\u62c6\u5b8c\u6210!")) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
            }
            return (T)splitSignupPurchaseResponseDto;
        }
        throw new BussinessException(SignupErrorCode.SPLITPURCHASE_ERROR);
    }

    public static String getTradeNo(@NonNull Long orgId, @NonNull Long purchaseId, @NonNull Double totalPrice, Collection<Header> headers) throws BussinessException {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        if (totalPrice == null) {
            throw new NullPointerException("totalPrice");
        }
        Preconditions.checkArgument((orgId > 0L ? 1 : 0) != 0, (Object)"org id can not be null");
        Preconditions.checkArgument((totalPrice >= 0.0 ? 1 : 0) != 0, (Object)"price must great than 0");
        String response = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pro_purchase_id", purchaseId.toString());
            params.put("pro_purchase_type", String.valueOf(PurchaseType.SIGNUP.getCode()));
            params.put("money", totalPrice.toString());
            params.put("user_id", orgId.toString());
            params.put("user_role", String.valueOf(UserRoleEnum.ORG.getCode()));
            params.put("tid", PayTerminal.PC.toString());
            String url = UrlProperties.getProperty("pay.createTradePurchase.url");
            logger.info("create trade purchase by params:{},url:{}", params, (Object)url);
            response = HttpClientUtils.doPost(url, params, DEF_CHARSET, headers);
            logger.info("create trade-->response {}", (Object)response);
            CreateTradePurchaseResponseDto responseDto = JacksonUtil.str2Obj(response, CreateTradePurchaseResponseDto.class);
            String tradeNO = responseDto.getData().getPlatformTradeNo();
            logger.info("create trade-->tradeNO {}", (Object)tradeNO);
            return tradeNO;
        }
        catch (Exception e) {
            logger.warn("create trade get error:{}", (Throwable)e);
            throw new BussinessException(SignupErrorCode.GETTRADENO_ERROR);
        }
    }

    public static Map<Long, Long> getTradeNoMap(Collection<Long> purchaseIds) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(purchaseIds), (Object)"purchaseIds can not be null");
        String response = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("purchase_ids", StringUtils.join(purchaseIds, (char)','));
            String url = UrlProperties.getProperty("pay.queryTradeNo.url");
            logger.info("get tradeNo map by params:{},url:{}", params, (Object)url);
            if (url == null) {
                return null;
            }
            response = HttpClientUtils.doPost(url, params, DEF_CHARSET);
            logger.info("get tradeNo map-->response {}", (Object)response);
            QueryTradeNoMapResponseDto responseDto = JacksonUtil.str2Obj(response, QueryTradeNoMapResponseDto.class);
            List<QueryTradeNoDataDto> data = responseDto.getData();
            if (CollectionUtils.isNotEmpty(data)) {
                return CollectorUtil.collectMap(data, new Function<QueryTradeNoDataDto, Long>(){

                    public Long apply(QueryTradeNoDataDto input) {
                        return input.getProPurchaseId();
                    }
                }, new Function<QueryTradeNoDataDto, Long>(){

                    public Long apply(QueryTradeNoDataDto input) {
                        return input.getPlatformTradeNo();
                    }
                });
            }
        }
        catch (Exception e) {
            logger.warn("get tradeNo map get error:{}", (Throwable)e);
        }
        return Maps.newHashMap();
    }

    public static PayResultDto getSignupPayResultDto(@NonNull Long signupPurchaseId) throws BussinessException, JsonParseException, JsonMappingException, IOException {
        if (signupPurchaseId == null) {
            throw new NullPointerException("signupPurchaseId");
        }
        Preconditions.checkArgument((signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"org id can not be null");
        String response = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("purchase_id", signupPurchaseId.toString());
            String url = UrlProperties.getProperty("pay.orgsignupdetail.url");
            logger.info("getSignuoPayResultDto by signupPurchaseId:{},url:{}", (Object)signupPurchaseId, (Object)url);
            response = HttpClientUtils.doPost(url, params, DEF_CHARSET);
            logger.info("getSignuoPayResultDto-->response {}", (Object)response);
        }
        catch (Exception e) {
            logger.warn("getSignuoPayResultDto get error:{}", (Throwable)e);
            throw new BussinessException(SignupErrorCode.SPLITPURCHASE_ERROR);
        }
        PayResultMapResponseDto responseDto = JacksonUtil.str2Obj(response, PayResultMapResponseDto.class);
        PayResultDto dto = responseDto.getData().getPayResultDto();
        return dto;
    }

    public static void main(String[] args) {
        double d1 = 1.0;
        System.out.println(20000.0);
    }

    public static enum RestMethod {
        GET,
        POST;

    }

    public static enum PayTerminal {
        PC(1),
        ANDROID(2),
        IPHONE(3),
        IPAD(4);

        private int code;

        private PayTerminal(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return String.valueOf(this.code);
        }
    }
}

