/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.request;

import com.baijia.tianxiao.util.GenericsUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(RequestUtils.class);

    public static String getParam(HttpServletRequest request, String name) {
        return RequestUtils.getStringParam(request, name);
    }

    public static String getParam(HttpServletRequest request, String name, String defaultValue) {
        return RequestUtils.getStringParam(request, name, defaultValue);
    }

    public static String getStringParam(HttpServletRequest request, String name) {
        return RequestUtils.getStringParam(request, name, "");
    }

    public static String getStringParam(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value.trim();
    }

    public static String[] getStringParams(HttpServletRequest request, String name, String[] defaultValues) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return defaultValues;
        }
        return values;
    }

    public static int getIntParam(HttpServletRequest request, String name) {
        return RequestUtils.getIntParam(request, name, 0);
    }

    public static int getIntParam(HttpServletRequest request, String name, int defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static byte getByteParam(HttpServletRequest request, String name) {
        return RequestUtils.getByteParam(request, name, (byte)0);
    }

    public static byte getByteParam(HttpServletRequest request, String name, byte defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public static long getLongParam(HttpServletRequest request, String name) {
        return RequestUtils.getLongParam(request, name, 0L);
    }

    public static long getLongParam(HttpServletRequest request, String name, long defaultValue) {
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        if (!StringUtils.isNumeric((String)(value = value.trim()))) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public static String getPostParamTK(HttpServletRequest request, String key) {
        String params = RequestUtils.getPostString(request);
        if (params != null && !params.equals("") && params.indexOf("\"tk\":\"") > 0) {
            params = params.substring(params.indexOf("\"tk\":\"") + 6);
            int len = 0;
            for (int i = 0; i < params.length(); ++i) {
                if (params.charAt(i) != '\"') continue;
                len = i;
                break;
            }
            params = params.substring(0, len);
            return params;
        }
        return null;
    }

    public static String getPostString(HttpServletRequest request) {
        byte[] data = RequestUtils.getPostData(request);
        return new String(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPostData(HttpServletRequest request) {
        BufferedInputStream bis = null;
        ByteArrayOutputStream baos = null;
        byte[] EMPTY_BYTES = new byte[]{};
        try {
            bis = new BufferedInputStream((InputStream)request.getInputStream());
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = bis.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    return EMPTY_BYTES;
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    return EMPTY_BYTES;
                }
            }
        }
    }

    public static String getServerHttpPath(HttpServletRequest request) {
        String fmt = "%s://%s/";
        return String.format(fmt, "http", request.getServerName());
    }

    public static String getHttpPath(HttpServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1, relativePath.length());
        }
        String fmt = "%s://%s/%s";
        return String.format(fmt, "http", request.getServerName(), relativePath);
    }

    public static String getParamFromCookie(HttpServletRequest request, String requestKey) {
        Cookie[] cookies = request.getCookies();
        if (GenericsUtils.notNullAndEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                String cName = cookie.getName();
                if (!cName.equals(requestKey)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Deprecated
    public static String getParamsString(HttpServletRequest request) {
        String characterEncoding = request.getCharacterEncoding();
        if (GenericsUtils.isNullOrEmpty(characterEncoding)) {
            characterEncoding = "utf-8";
        }
        StringBuilder sb = new StringBuilder();
        Map parameterMap = request.getParameterMap();
        if (GenericsUtils.notNullAndEmpty(parameterMap)) {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String[] paramValues;
                String paramName = (String)entry.getKey();
                for (String value : paramValues = (String[])entry.getValue()) {
                    try {
                        sb.append(URLEncoder.encode(paramName, characterEncoding)).append("=").append(URLEncoder.encode(value, characterEncoding));
                    }
                    catch (UnsupportedEncodingException e) {
                        GenericsUtils.logErrorAndInfo(log, (Exception)e, "can not encode queryParam:{} or paramValue:{} with charset:{} ", paramName, value, characterEncoding);
                    }
                }
                sb.append("&");
            }
        }
        return GenericsUtils.deleteLastCharToString(sb);
    }
}

