/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.exception;

import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;

public class BussinessPreconditions {
    private BussinessPreconditions() {
    }

    public static void checkArgument(boolean expression) {
        BussinessPreconditions.checkArgument(expression, CommonErrorCode.BUSINESS_ERROR);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode) {
        if (!expression) {
            throw new BussinessException(errorCode);
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        BussinessPreconditions.checkArgument(expression, CommonErrorCode.BUSINESS_ERROR, errorMessage);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode, Object errorMessage) {
        if (!expression) {
            throw new BussinessException(errorCode, String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        BussinessPreconditions.checkArgument(expression, CommonErrorCode.BUSINESS_ERROR, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new BussinessException(errorCode, BussinessPreconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

