/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.collection;

import com.baijia.tianxiao.util.collection.Calculate;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class CollectorUtil {
    public static <K, V> Map<K, List<V>> group(Collection<V> values, Function<V, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        for (V v : values) {
            Object key = keyFun.apply(v);
            if (key == null) continue;
            if (!result.containsKey(key)) {
                result.put(key, new ArrayList());
            }
            ((List)result.get(key)).add(v);
        }
        return result;
    }

    public static <K, V, O> Map<K, List<V>> group(Collection<O> values, Function<O, K> keyFun, Function<O, V> valueFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap results = new HashMap();
        for (O o : values) {
            Object key = keyFun.apply(o);
            if (key == null) continue;
            if (!results.containsKey(key)) {
                results.put(key, new ArrayList());
            }
            ((List)results.get(key)).add(valueFun.apply(o));
        }
        return results;
    }

    public static <K, V, O> Map<K, V> collectMap(Collection<O> values, Function<O, K> keyFun, Function<O, V> valueFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> results = new HashMap<Object, Object>();
        for (O o : values) {
            Object key = keyFun.apply(o);
            if (key == null) continue;
            results.put(key, valueFun.apply(o));
        }
        return results;
    }

    public static <K, O> Map<K, O> collectMap(Collection<O> values, Function<O, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyMap();
        }
        HashMap<Object, O> results = new HashMap<Object, O>();
        for (O o : values) {
            Object key = keyFun.apply(o);
            if (key == null) continue;
            results.put(key, o);
        }
        return results;
    }

    public static <K, V> Map<K, V> groupAndCalcu(Collection<V> values, Function<V, K> keyFun, Calculate<V> calculateFun) {
        return CollectorUtil.groupAndCalcu(values, null, keyFun, calculateFun);
    }

    public static <K, V> Map<K, V> groupAndCalcu(Collection<V> values, Map<K, V> result, Function<V, K> keyFun, Calculate<V> calculateFun) {
        if (result == null) {
            result = new HashMap();
        }
        if (CollectionUtils.isEmpty(values)) {
            return result;
        }
        for (V v : values) {
            Object key = keyFun.apply(v);
            if (key == null) continue;
            result.put(key, calculateFun.calc(result.get(key), v));
        }
        return result;
    }

    public static <K, O> Collection<K> collect(Collection<O> values, Function<O, K> keyFun) {
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        HashSet<Object> results = new HashSet<Object>();
        for (O o : values) {
            Object k = keyFun.apply(o);
            if (k == null) continue;
            results.add(k);
        }
        return results;
    }
}

