/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.bean;

import com.baijia.tianxiao.util.GenericsUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Scanner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class LoggerService {
    private static LoggerLevel settingLevel = LoggerLevel.INFO;
    private static LogService logService;
    private static String outputFild;
    private static final BlockingQueue<String> infoQueue;

    public static void main(String[] args) throws URISyntaxException {
        LoggerService.info("hahah", new Object[0]);
    }

    private static void initLogService() {
        File file;
        logService = new LogService(infoQueue);
        logService.setDaemon(true);
        String property = System.getProperty("user.dir");
        if (GenericsUtils.notNullAndEmpty(property) && (file = new File(property)) != null && file.exists()) {
            outputFild = file.getParentFile().getAbsolutePath();
            outputFild = outputFild + File.separator + "logs" + File.separator + "logService.log";
            System.out.println("======= outputFild is:" + outputFild);
        }
        if (outputFild != null && outputFild.length() > 0) {
            LoggerService.setOutputFile(outputFild);
        }
        logService.start();
    }

    public static void info(Object ... printObjs) {
        LoggerService.logMessage("", LoggerLevel.INFO, printObjs);
    }

    public static void info(String format, Object ... printObjs) {
        LoggerService.logMessage(format, LoggerLevel.INFO, printObjs);
    }

    public static void infoArray(String format, Object printObjs) {
        LoggerService.logMessage(format, LoggerLevel.INFO, printObjs);
    }

    public static void debug(String format, Object ... printObjs) {
        LoggerService.logMessage(format, LoggerLevel.DEBUG, printObjs);
    }

    public static void debugArray(String format, Object printObjs) {
        LoggerService.logMessage(format, LoggerLevel.DEBUG, printObjs);
    }

    public static void error(String format, Object ... printObjs) {
        LoggerService.logMessage(format, LoggerLevel.ERROR, printObjs);
    }

    public static void errorArray(String format, Object printObjs) {
        LoggerService.logMessage(format, LoggerLevel.ERROR, printObjs);
    }

    public static void warn(String format, Object ... printObjs) {
        LoggerService.logMessage(format, LoggerLevel.WARN, printObjs);
    }

    public static void warnArray(String format, Object ... printObjs) {
        LoggerService.logMessage(format, LoggerLevel.WARN, printObjs);
    }

    public static void startLogService() {
        LoggerService.initLogService();
    }

    public static void stopLogService() {
        logService.stopLogService();
    }

    private static void logMessage(String format, LoggerLevel level, Object ... printObjs) {
        printObjs = LoggerService.checkoutIfArray(printObjs);
        String formatOutput = format.replace("{}", "%s");
        if (format.equalsIgnoreCase(formatOutput) && printObjs != null && printObjs.length != 0) {
            for (int i = 0; i < printObjs.length; ++i) {
                formatOutput = formatOutput + " %s ";
            }
        }
        LoggerService.createCodeInfos(String.format(formatOutput, LoggerService.checkoutIfIsExceptioin(printObjs)), level);
    }

    private static Object[] checkoutIfIsExceptioin(Object ... printObjs) {
        Object[] retObj = new Object[printObjs.length];
        for (int i = 0; i < printObjs.length; ++i) {
            retObj[i] = printObjs[i];
            Object obj = retObj[i];
            if (!(obj instanceof Throwable)) continue;
            retObj[i] = LoggerService.createExceptionOutput((Throwable)obj);
        }
        return retObj;
    }

    private static Object createExceptionOutput(Throwable obj) {
        StringWriter sw = new StringWriter();
        obj.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static Object[] checkoutIfArray(Object ... printObjs) {
        Object listObj;
        if (printObjs != null && printObjs.length == 1 && (listObj = printObjs[0]) != null && listObj.getClass().isArray()) {
            Class<?> class1 = listObj.getClass();
            Object[] createArray = LoggerService.createArrayFromObj(listObj, class1);
            return new String[]{Arrays.toString(createArray)};
        }
        return printObjs;
    }

    private static Object[] createArrayFromObj(Object listObj, Class<? extends Object> class1) {
        Class<?> componentType = class1.getComponentType();
        int size = Array.getLength(listObj);
        Object[] createArray = LoggerService.createArray(componentType, size);
        for (int i = 0; i < size; ++i) {
            createArray[i] = Array.get(listObj, i);
        }
        return createArray;
    }

    private static void createCodeInfos(String message, LoggerLevel level) {
        String printStr = message;
        if (LoggerService.checkLevel(level)) {
            printStr = LoggerService.createLoggerInfo(message, level, printStr);
            try {
                logService.log(printStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String createLoggerInfo(String message, LoggerLevel level, String printStr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable t = new Throwable();
        t.printStackTrace(pw);
        String stackInfo = sw.toString();
        Scanner scanner = new Scanner(stackInfo);
        String line = null;
        scanner.nextLine();
        while (scanner.hasNextLine() && (line = scanner.nextLine()).trim().startsWith("at " + LoggerService.class.getName())) {
        }
        scanner.close();
        if (line != null && line.length() > 0) {
            String retStr = line.substring(line.indexOf("at") + 3);
            printStr = LoggerInfos.instance(retStr, level, message);
        }
        return printStr;
    }

    private static boolean checkLevel(LoggerLevel level) {
        return LoggerLevel.isOverLevel(settingLevel, level);
    }

    public static void setLoggerLevel(LoggerLevel level) {
        settingLevel = level;
    }

    public static void setOutputFile(String filePathName) {
        if (filePathName == null || filePathName.length() == 0) {
            return;
        }
        File outputFile = null;
        if (filePathName.contains(File.separator)) {
            outputFile = new File(filePathName);
        } else {
            File classpath;
            if (!filePathName.contains(".")) {
                filePathName = filePathName + ".log";
            }
            if ((classpath = LoggerService.getClasspath()) == null) {
                return;
            }
            outputFile = new File(classpath, filePathName);
        }
        if (!outputFile.exists()) {
            try {
                outputFile.createNewFile();
            }
            catch (IOException e) {
                System.out.println("can not createOutputFile: " + outputFile.getAbsolutePath());
                return;
            }
        }
        System.out.println("==== output File is :{} " + outputFile.getAbsolutePath());
        try {
            PrintWriter outputFilePw = new PrintWriter((Writer)new FileWriter(outputFile, false), true);
            outputFild = outputFile.getAbsolutePath();
            logService.setPrintWriter(outputFilePw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getClasspath() {
        File file = null;
        try {
            file = new File(LoggerService.class.getClassLoader().getResource("").toURI());
            return file;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private static <T> T[] createArray(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static String formatOutput(String format, Object ... params) {
        return String.format(format.replace("{}", "%s"), params);
    }

    static {
        infoQueue = new LinkedBlockingQueue<String>();
        LoggerService.initLogService();
    }

    static class LoggerInfos {
        private String line;
        private String packageName;
        private String methodName;
        private String executeTime;
        private String stackLineInfo;
        private static final String FORMAT = "%s %s [%s] %s : %s";
        private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        LoggerInfos(String stackLineInfo) {
            this(stackLineInfo, "");
        }

        public LoggerInfos(String stackLineInfo, String timeInfo) {
            this.stackLineInfo = stackLineInfo;
            this.executeTime = timeInfo;
        }

        public String simpleFormat(String output, LoggerLevel level) {
            return String.format(FORMAT, this.executeTime, Thread.currentThread().getName(), level.getShow(), this.stackLineInfo, output);
        }

        public static LoggerInfos instance(String stackInfo) {
            LoggerInfos li = new LoggerInfos(stackInfo, LoggerInfos.simpleFormatDateStr());
            return li;
        }

        public static String instance(String stackInfo, LoggerLevel level, String afterFormat) {
            LoggerInfos li = new LoggerInfos(stackInfo, LoggerInfos.simpleFormatDateStr());
            return li.simpleFormat(afterFormat, level);
        }

        public static Date simpleFormatDateStr(String valueStr) {
            try {
                return sdf.parse(valueStr);
            }
            catch (ParseException e) {
                return new Date();
            }
        }

        public static String simpleFormatDateStr() {
            return sdf.format(new Date());
        }

        public String getLine() {
            return this.line;
        }

        public void setLine(String line) {
            this.line = line;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getExecuteTime() {
            return this.executeTime;
        }

        public void setExecuteTime(String executeTime) {
            this.executeTime = executeTime;
        }

        public String getStackLineInfo() {
            return this.stackLineInfo;
        }

        public void setStackLineInfo(String stackLineInfo) {
            this.stackLineInfo = stackLineInfo;
        }
    }

    public static enum LoggerLevel {
        ERROR(0),
        WARN(1),
        INFO(2),
        DEBUG(3);

        public int sort;

        private LoggerLevel(int sort) {
            this.sort = sort;
        }

        public String getShow() {
            return this.name();
        }

        public static boolean isOverLevel(LoggerLevel settingLevel, LoggerLevel currentLevel) {
            return settingLevel.sort >= currentLevel.sort;
        }
    }

    private static class LogService
    extends Thread {
        BlockingQueue<String> outputInfoQueue;
        volatile AtomicBoolean isStopService = new AtomicBoolean(false);
        AtomicInteger needLogCount = new AtomicInteger(0);
        PrintWriter outputPw = null;

        LogService(BlockingQueue<String> infoqueue) {
            this.outputInfoQueue = infoQueue;
            assert (this.outputInfoQueue != null);
        }

        void log(String outputInfo) throws InterruptedException {
            if (this.isStopService()) {
                throw new IllegalStateException("logService is closeed");
            }
            this.needLogCount.incrementAndGet();
            this.outputInfoQueue.put(outputInfo);
        }

        void setPrintWriter(PrintWriter pw) {
            this.outputPw = pw;
        }

        @Override
        public void run() {
            block12: {
                try {
                    while (true) {
                        try {
                            while (true) {
                                if (this.isStopService() && this.needLogCount.decrementAndGet() < 0) {
                                    System.out.println("======Log Service Stop Successfully=====");
                                    break block12;
                                }
                                String take = this.outputInfoQueue.take();
                                if (this.outputPw != null) {
                                    this.outputPw.println(take);
                                    this.outputPw.flush();
                                    continue;
                                }
                                System.out.println(take);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            System.out.println("receive a interruptedException , so will try to stop log service ");
                            this.isStopService.set(true);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (this.outputPw != null) {
                        this.outputPw.close();
                    }
                }
            }
        }

        private boolean isStopService() {
            return this.isStopService.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopLogService() {
            LogService logService = this;
            synchronized (logService) {
                this.isStopService.getAndSet(true);
                this.interrupt();
            }
        }
    }
}

