/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util.bean;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class AtomicComputeCache<K, V> {
    private ConcurrentMap<K, ComputableTask<K>> computingCache;
    private ConcurrentMap<K, V> computeResultCache;

    public AtomicComputeCache() {
        this.computingCache = new ConcurrentHashMap<K, ComputableTask<K>>();
        this.computeResultCache = new ConcurrentHashMap();
    }

    public AtomicComputeCache(int initialCapacity) {
        this.computingCache = new ConcurrentHashMap<K, ComputableTask<K>>(initialCapacity);
        this.computeResultCache = new ConcurrentHashMap(initialCapacity);
    }

    public V getComputeResult(K key, Callable<V> biz) {
        if (this.computeResultCache.containsKey(key)) {
            return this.computeResultCache.get(key);
        }
        if (this.computingCache.containsKey(key)) {
            biz = null;
            ComputableTask task = (ComputableTask)this.computingCache.get(key);
            if (task == null) {
                return this.computeResultCache.get(key);
            }
            Object result = task.getValue(key, this.computingCache);
            this.swapResultAndCleanComputeTask(key, result);
            return (V)result;
        }
        ComputableTask<K> task = new ComputableTask<K>(biz);
        ComputableTask old = this.computingCache.putIfAbsent(key, task);
        if (old == null) {
            if (this.computeResultCache.containsKey(key)) {
                Object result = this.computeResultCache.get(key);
                this.swapResultAndCleanComputeTask(key, result);
                return result;
            }
            task.run();
        } else {
            task = old;
        }
        Object result = task.getValue(key, this.computingCache);
        this.swapResultAndCleanComputeTask(key, result);
        return (V)result;
    }

    public V preGetAlreadyDoneResult(K key) {
        return this.computeResultCache.get(key);
    }

    private void swapResultAndCleanComputeTask(K key, V result) {
        this.computeResultCache.put(key, result);
        this.computingCache.remove(key);
    }

    private static class ComputableTask<K>
    extends FutureTask<Object> {
        public ComputableTask(Callable<Object> callable) {
            super(callable);
        }

        public Object getValue(K key, ConcurrentMap<K, ComputableTask<K>> computingCache) {
            try {
                return this.get();
            }
            catch (InterruptedException e) {
                computingCache.remove(key);
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                computingCache.remove(key);
                throw new RuntimeException(e);
            }
        }
    }
}

