/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.util;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.constants.sms.TxSmsCodeType;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.StringUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsContentHelper {
    private static final Logger log = LoggerFactory.getLogger(SmsContentHelper.class);
    private static final int MAX_COURSE_NAME_LENGTH = 11;
    private static final int MAX_ORG_NAME_LENGTH = 9;
    private static final int MAX_TEACHER_NAME_LENGTH = 6;
    public static String defaultServerPhone = "4000910910";
    public static String defaultDownUrl = "http://tianxiao100.com/download.do";
    public static String DEFAULT_SMS_SIGN_CONTENT = "\u5929\u6821";
    private static final String COURSE_TIME_FORMAT = "MM\u6708dd\u65e5 HH:mm";
    private static final String COURSE_TIME_FORMAT_NOT_MH = "MM\u6708dd\u65e5";
    private static final String YEAR_TIME_FORMAT = "YYYY\u5e74MM\u6708dd\u65e5 HH:mm";
    private static final String YEAR_TIME_FORMAT_NOT_MH = "YYYY\u5e74MM\u6708dd\u65e5";

    public static int countChargeSmsNum(String content, String signName) {
        if (StringUtils.isEmpty(content) || StringUtils.isEmpty(signName)) {
            return 1;
        }
        StringBuilder sb = new StringBuilder(content).append("\u3010").append(signName).append("\u3011");
        if (sb.toString().length() <= 70) {
            return 1;
        }
        System.out.println(sb.toString().length());
        System.out.println(sb.toString().length() / 67);
        if (sb.toString().length() % 67 == 0) {
            return sb.toString().length() / 67;
        }
        return sb.toString().length() / 67 + 1;
    }

    public static String createMPaySmsCodeSmsMsg(String verifyCode, int timeStep) {
        return String.format(TxSmsCodeType.M_PAY_SMS_CODE.getMsg(), verifyCode, timeStep);
    }

    public static String createSignupPaySmsMsg(String courseName, String orgName, String url, int courseNum) {
        courseName = SmsContentHelper.replaceSpecialSign(courseName);
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        courseName = SmsContentHelper.solveLength(courseName, 11);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        if (courseNum > 1) {
            return String.format(TxSmsCodeType.SIGNUP_PAY_SMS_CONTENT_MANY_TEMPLATE.getMsg(), courseName, courseNum, url, orgName);
        }
        return String.format(TxSmsCodeType.SIGNUP_PAY_SMS_CONTENT_SIGNAL_TEMPLATE.getMsg(), courseName, url, orgName);
    }

    public static String createForgetPwdSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.FORGOTPWD_VALID_CODE_CONTENT.getMsg(), code, timeStep, defaultServerPhone);
    }

    public static String createApplyTXSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.APPLY.getMsg(), code, timeStep, defaultServerPhone);
    }

    public static String createSavePayPwdSmsMsg(String code, int timeStep) {
        return String.format(TxSmsCodeType.SAVE_PAY_PWD.getMsg(), code, timeStep, defaultServerPhone);
    }

    public static String createTryExpTianxiaoTemplateSmsMsg(String userName, String pwd, int defaultVisitorDay) {
        userName = SmsContentHelper.replaceSpecialSign(userName);
        return String.format(TxSmsCodeType.TRY_OPEN_TEMPLATE.getMsg(), userName, pwd, defaultVisitorDay, SmsContentHelper.getAppDownload());
    }

    public static String createDaZhongBanKaiTongSmsMsg() {
        return String.format(TxSmsCodeType.OPEN_DAZHONGBAN.getMsg(), defaultServerPhone);
    }

    public static String createVisitorAccountExpireNotifySmsMsg() {
        return String.format(TxSmsCodeType.ONE_DAY_REMAIND_TEMPLATE.getMsg(), SmsContentHelper.getAppDownload());
    }

    public static String createVisitorAccountExpired() {
        return String.format(TxSmsCodeType.HAS_RELEASE_TEMPLATE.getMsg(), defaultServerPhone);
    }

    public static String createNewOrgPwdSmsContent(String mobile, String pwd) {
        String content = String.format(TxSmsCodeType.NEW_ORG_PWD.getMsg(), mobile, pwd, SmsContentHelper.getAppDownload());
        return content;
    }

    public static String createNewNewCascadePwdSmsMsg(String mobile, String pwd) {
        String content = String.format(TxSmsCodeType.NEW_CASCADE_PWD.getMsg(), mobile, pwd, SmsContentHelper.getAppDownload());
        return content;
    }

    public static String createInviteToBeCampus(String code, String mainOrgName, String subOrgName) {
        mainOrgName = SmsContentHelper.replaceSpecialSign(mainOrgName);
        subOrgName = SmsContentHelper.replaceSpecialSign(subOrgName);
        String content = String.format(TxSmsCodeType.INVITE_TOBE_CAMPUS.getMsg(), code, mainOrgName, subOrgName, defaultServerPhone);
        return content;
    }

    public static String createModOrgMobileSms(String code, int timeStep) {
        return String.format(TxSmsCodeType.MOD_ORG_MOBILE.getMsg(), code, timeStep, defaultServerPhone);
    }

    public static String createUnBindBankCard(String orgName, String card) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        return String.format(TxSmsCodeType.ORG_BANK_UNBIND_CARD.getMsg(), orgName, card, defaultServerPhone);
    }

    public static String createBindBankCard(String orgName, String card) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        return String.format(TxSmsCodeType.ORG_BANK_BIND_CARD.getMsg(), orgName, card, defaultServerPhone);
    }

    public static String createTeacherClassSchedule(String orgCourseName, String orgName, String url) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgCourseName = SmsContentHelper.replaceSpecialSign(orgCourseName);
        orgCourseName = SmsContentHelper.solveLength(orgCourseName, 11);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        return SmsContentHelper.createClassSchedule(orgCourseName, orgName, url);
    }

    public static String createStudentClassSchedule(String orgCourseName, String orgName, String url) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgCourseName = SmsContentHelper.replaceSpecialSign(orgCourseName);
        orgCourseName = SmsContentHelper.solveLength(orgCourseName, 11);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        return SmsContentHelper.createClassSchedule(orgCourseName, orgName, url);
    }

    public static String createClassNotify(long classTime, String orgCourseName, String orgName) {
        String classTimeStr = SmsContentHelper.formatCourseTime(classTime, true);
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgCourseName = SmsContentHelper.replaceSpecialSign(orgCourseName);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        orgCourseName = SmsContentHelper.solveLength(orgCourseName, 11);
        return String.format(TxSmsCodeType.CLASS_NOTIFY.getMsg(), classTimeStr, orgCourseName, orgName);
    }

    public static String createVZBSpeak(String code, int timeStep) {
        return String.format(TxSmsCodeType.VZHIBO_CONSULT_MOBILE_KEY.getMsg(), code, timeStep, defaultServerPhone);
    }

    public static String createBirthdaySmsMsg(String studentName, String orgName) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        studentName = SmsContentHelper.replaceSpecialSign(studentName);
        studentName = SmsContentHelper.solveLength(studentName, 6);
        return String.format(TxSmsCodeType.BIRTHDAY_NOTIFY.getMsg(), studentName, orgName);
    }

    public static String createSignupCourseSmsMsg(String courseName, int courseCount, String orgName) {
        courseName = SmsContentHelper.replaceSpecialSign(courseName);
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        courseName = SmsContentHelper.solveLength(courseName, 11);
        if (courseCount > 1) {
            return String.format(TxSmsCodeType.SIGNUP_NOTIFY_WITH_MANY.getMsg(), courseName, courseCount, orgName);
        }
        return String.format(TxSmsCodeType.SIGNUP_NOTIFY_WITH_SIGNAL.getMsg(), courseName, orgName);
    }

    public static String createSignRecordSmsMsg(int type, String studentName, Long courseTime, String courseName, String orgName) {
        studentName = SmsContentHelper.replaceSpecialSign(studentName);
        studentName = SmsContentHelper.solveLength(studentName, 6);
        courseName = SmsContentHelper.replaceSpecialSign(courseName);
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        String courseTimeStr = null == courseTime ? "-" : SmsContentHelper.formatCourseTime(courseTime, true);
        courseName = SmsContentHelper.solveLength(courseName, 11);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        TxSmsCodeType typeEnum = TxSmsCodeType.SIGN_NOTIFY_PRESENT;
        if (StringUtils.isEmpty(courseName) && type == 1) {
            return String.format(TxSmsCodeType.SIGN_NOTIFY_NOCOURSE_PRESENT.getMsg(), studentName, courseTimeStr, orgName);
        }
        if (type == 2) {
            typeEnum = TxSmsCodeType.SIGN_NOTIFY_LEAVE;
        } else if (type == 3) {
            typeEnum = TxSmsCodeType.SIGN_NOTIFY_NOT_PRESENT;
        }
        return String.format(typeEnum.getMsg(), studentName, courseTimeStr, courseName, orgName);
    }

    public static String createCommentNotifySmsMsg(String teacherName, long courseTime, String orgName, String url) {
        teacherName = SmsContentHelper.replaceSpecialSign(teacherName);
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        teacherName = SmsContentHelper.solveLength(teacherName, 6);
        orgName = SmsContentHelper.solveLength(orgName, 7);
        String courseTimeStr = SmsContentHelper.formatCourseTime(courseTime, false);
        return String.format(TxSmsCodeType.COMMENT_NOTIFY.getMsg(), teacherName, courseTimeStr, url, orgName);
    }

    public static String createNotifyCommentToStuSmsMsg(String teacherName, long courseTime, String url, String orgName) {
        teacherName = SmsContentHelper.solveLength(teacherName, 6);
        orgName = SmsContentHelper.solveLength(orgName, 7);
        String courseTimeStr = SmsContentHelper.formatCourseTime(courseTime, false);
        return String.format(TxSmsCodeType.NOTIFY_TO_COMMENT.getMsg(), courseTimeStr, teacherName, url, orgName);
    }

    public static String createRechargeSms(String studentName, long createTime, Double money, String orgName) {
        String createTimeStr = SmsContentHelper.formatCourseTime(createTime, true);
        orgName = SmsContentHelper.solveLength(orgName, 7);
        return String.format(TxSmsCodeType.RECHARGE_SMS_CODE.getMsg(), studentName, createTimeStr, money, orgName);
    }

    public static String createTimescardSms(long createTime, int lessonCount, Date endTime, String orgName) {
        String createTimeStr = SmsContentHelper.formatCourseTime(createTime, true);
        String endTimeStr = SmsContentHelper.formatYearTime(endTime.getTime(), false);
        orgName = SmsContentHelper.solveLength(orgName, 7);
        if (lessonCount < 0) {
            return String.format(TxSmsCodeType.TIMECARD_SMS_CODE_NO_COUNT.getMsg(), createTimeStr, endTimeStr, orgName);
        }
        return String.format(TxSmsCodeType.TIMECARD_SMS_CODE_COUNT.getMsg(), createTimeStr, lessonCount, orgName);
    }

    public static String createTimescardValid(long endTime, String orgName) {
        String endTimeStr = SmsContentHelper.formatCourseTime(endTime, false);
        orgName = SmsContentHelper.solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_VALID.getMsg(), endTimeStr, orgName);
    }

    public static String createTimescardDelay(Date delayDate, String orgName) {
        orgName = SmsContentHelper.solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_DELAY.getMsg(), DateUtil.getStrByDate(delayDate), orgName);
    }

    public static String createTimescardExhausted(String orgName) {
        orgName = SmsContentHelper.solveLength(orgName, 7);
        return String.format(TxSmsCodeType.TIMECARD_EXHAUSTED.getMsg(), orgName);
    }

    public static String createBindWeixinSmsMsg(String code, int timeStep, String orgName) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        return String.format(TxSmsCodeType.BIND_WEIXIN.getMsg(), code, timeStep, orgName);
    }

    public static String createUCChangeMobileSmsMsg(String code, int timeStep, String orgName) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        return String.format(TxSmsCodeType.USERCENTER_CHANGE_MOBILE.getMsg(), code, timeStep, orgName);
    }

    public static String createUCBindStuSmsMsg(String code, int timeStep, String orgName) {
        orgName = SmsContentHelper.replaceSpecialSign(orgName);
        orgName = SmsContentHelper.solveLength(orgName, 9);
        return String.format(TxSmsCodeType.USERCENTER_BIND_STU.getMsg(), code, timeStep, orgName);
    }

    public static String createMarktingSmsMsg(String content, String branchSchoolName) {
        return String.format(TxSmsCodeType.TX_MARKTING_SMS.getMsg(), content, branchSchoolName);
    }

    public static String createTxCodeMsg(String code) {
        return String.format(TxSmsCodeType.TX_VERTY_CODE.getMsg(), code);
    }

    public static String createConsultRecall(String name, String phone) {
        name = SmsContentHelper.replaceSpecialSign(name);
        return String.format(TxSmsCodeType.TX_CONSULT_RECALL.getMsg(), name, phone);
    }

    public static String createConsultRecallContact(String name, String contact, String phone) {
        name = SmsContentHelper.replaceSpecialSign(name);
        contact = SmsContentHelper.replaceSpecialSign(contact);
        return String.format(TxSmsCodeType.TX_CONSULT_RECALL_CONTACT.getMsg(), name, contact, phone);
    }

    public static String getAppDownload() {
        try {
            String url = PropertiesReader.getValue((String)"tianxiao", (String)"message.url");
            return ShortUrlUtil.getShortUrl(url, true);
        }
        catch (Exception e) {
            log.error("error :{} ", (Throwable)e);
            return defaultDownUrl;
        }
    }

    public static String getShortUrl(String url) {
        if (GenericsUtils.isNullOrEmpty(url)) {
            return "";
        }
        try {
            return ShortUrlUtil.getShortUrl(url, true);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String createClassSchedule(String courseName, String orgName, String url) {
        url = ShortUrlUtil.getShortUrl(url, true);
        return String.format(TxSmsCodeType.TEACHER_CLASS_SCHEDULE.getMsg(), courseName, url, orgName);
    }

    private static String formatCourseTime(long classTime, boolean needHM) {
        SimpleDateFormat format = null;
        format = needHM ? new SimpleDateFormat(COURSE_TIME_FORMAT) : new SimpleDateFormat(COURSE_TIME_FORMAT_NOT_MH);
        return format.format(new Date(classTime));
    }

    private static String formatYearTime(long classTime, boolean needHM) {
        SimpleDateFormat format = null;
        format = needHM ? new SimpleDateFormat(YEAR_TIME_FORMAT) : new SimpleDateFormat(YEAR_TIME_FORMAT_NOT_MH);
        return format.format(new Date(classTime));
    }

    private static String solveLength(String orgName, int length) {
        int infoLength = orgName.length();
        if (infoLength > length) {
            orgName = orgName.substring(0, length) + "...";
        }
        return orgName;
    }

    private static String replaceSpecialSign(String str) {
        return null == str ? "" : str.replaceAll("\u3010", "[").replaceAll("\u3011", "]");
    }

    public static void main(String[] args) {
        System.out.print(SmsContentHelper.createBindBankCard("sdfdsf", "12321321"));
    }
}

