/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.interceptor;

import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.util.http.WebCommonsUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class LogInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.info("Log interceptor:preHandle:{},{}", (Object)request.getRequestURL().toString());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        log.info("Log interceptor:postHandle:{}", (Object)request.getRequestURL().toString());
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        String ip = WebCommonsUtils.getIpAddr(request);
        String domain = request.getServerName();
        String path = request.getRequestURI();
        Map<String, String> params = WebCommonsUtils.getParameterMap(request);
        Integer orgId = TianxiaoPCContext.getOrgId();
        Integer cascadeId = TianxiaoPCContext.getTXCascadeId();
        String logId = request.getParameter("logId");
        log.info("Log interceptor:afterCompletion:{},{},{},{},{},{}", new Object[]{ip, domain, path, params, orgId, cascadeId, logId});
    }
}

