/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.interceptor;

import com.baijia.tianxiao.dto.AppBaseResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.util.json.JacksonUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ErrorInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ErrorInterceptor.class);

    public void afterCompletion(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler, Exception ex) throws Exception {
        if (null != ex) {
            this.handUnDeclaredException(ex, httpResponse);
        }
    }

    protected void handUnDeclaredException(Throwable ex, HttpServletResponse httpResponse) {
        AppBaseResponse response = new AppBaseResponse("\u7f51\u7edc\u5f02\u5e38", CommonErrorCode.SYSTEM_ERROR.getSubsystemErrorCode(), null);
        String simpleName = ex.getClass().getSimpleName();
        if (simpleName.equals("ClientAbortException")) {
            log.warn("ClientAbortException {}", ex);
        } else {
            log.error("Handled unDeclared error ", ex);
        }
        try {
            httpResponse.setContentType("application/json;charset=UTF-8");
            JacksonUtil.writeObj((OutputStream)httpResponse.getOutputStream(), response);
        }
        catch (IOException e) {
            simpleName = e.getClass().getSimpleName();
            if (simpleName.equals("ClientAbortException")) {
                log.warn("ClientAbortException {}", (Throwable)e);
            }
            log.error("ioexception:{}", (Throwable)e);
        }
    }
}

