/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.excel;

import com.baijia.tianxiao.excel.ExcelCell;
import com.baijia.tianxiao.excel.ExcelCellStyle;
import com.baijia.tianxiao.excel.Excelable;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.POIXMLException;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExporter {
    private static final Logger log = LoggerFactory.getLogger(ExcelExporter.class);

    protected <A> void exportToExcel(OutputStream outputStream, String fileName, String sheetName, List<A> datas, Excelable<A> exporter) {
        block4: {
            HSSFWorkbook wb = new HSSFWorkbook();
            if (StringUtils.isBlank((String)sheetName)) {
                sheetName = "ExportDataList";
            }
            this.createSheet((Workbook)wb, sheetName, datas, exporter);
            if (StringUtils.isBlank((String)fileName)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
                fileName = sdf.format(new Date()) + ".xls";
            }
            try {
                wb.write(outputStream);
            }
            catch (IOException e) {
                String simplename = e.getClass().getSimpleName();
                if (!"ClientAbortException".equals(simplename)) break block4;
                log.warn("Error while exporting data.And it's a ClientAbortException");
            }
        }
    }

    protected <A> void exportToExcel(HttpServletResponse response, String fileName, String sheetName, List<A> datas, Excelable<A> exporter) {
        block5: {
            if (GenericsUtils.notNullAndEmpty(datas) && datas.size() > 6000) {
                this.exportToExcelZip(response, fileName, sheetName, datas, exporter);
                return;
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            if (StringUtils.isBlank((String)sheetName)) {
                sheetName = "ExportDataList";
            }
            this.createSheet((Workbook)wb, sheetName, datas, exporter);
            if (StringUtils.isBlank((String)fileName)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
                fileName = sdf.format(new Date()) + ".xls";
            }
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            try {
                wb.write((OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                String simplename = e.getClass().getSimpleName();
                if (!"ClientAbortException".equals(simplename)) break block5;
                log.warn("Error while exporting data.And it's a ClientAbortException");
            }
        }
    }

    protected <A> void exportToExcelZip(HttpServletResponse response, String fileName, String sheetName, List<A> datas, Excelable<A> exporter) {
        block19: {
            String simplename;
            File zipFile;
            block18: {
                ArrayList<File> files;
                block17: {
                    if (StringUtils.isBlank((String)sheetName)) {
                        sheetName = "ExportDataList";
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss_");
                    if (StringUtils.isBlank((String)fileName)) {
                        fileName = sdf.format(new Date());
                    }
                    files = new ArrayList<File>();
                    FileOutputStream fileOut = null;
                    File dic = new File("../exportExcel");
                    if (!dic.exists()) {
                        dic.mkdir();
                    }
                    try {
                        int sheetNum = datas.size() / 60000;
                        for (int i = 0; i < sheetNum + 1; ++i) {
                            HSSFWorkbook wb = new HSSFWorkbook();
                            File file = new File("../exportExcel/" + fileName + "_" + i + ".xls");
                            file.createNewFile();
                            files.add(file);
                            fileOut = new FileOutputStream(file);
                            if (i == sheetNum) {
                                this.createSheet((Workbook)wb, sheetName, datas.subList(60000 * sheetNum, datas.size()), exporter);
                            } else {
                                this.createSheet((Workbook)wb, sheetName, datas.subList(60000 * i, 60000 * (i + 1)), exporter);
                            }
                            wb.write((OutputStream)fileOut);
                            try {
                                fileOut.close();
                                continue;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (IOException e) {
                        String simplename2 = e.getClass().getSimpleName();
                        if (!"ClientAbortException".equals(simplename2)) break block17;
                        log.warn("Error while exporting data.And it's a ClientAbortException");
                    }
                }
                byte[] buf = new byte[1024];
                zipFile = new File("../exportExcel/" + fileName + "_Excels.zip");
                try {
                    if (!zipFile.exists()) {
                        zipFile.createNewFile();
                    }
                    ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
                    for (File file : files) {
                        int len;
                        FileInputStream in = new FileInputStream(file);
                        out.putNextEntry(new ZipEntry(file.getName()));
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        out.closeEntry();
                        in.close();
                        file.delete();
                    }
                    out.close();
                }
                catch (Exception e) {
                    simplename = e.getClass().getSimpleName();
                    if (!"ClientAbortException".equals(simplename)) break block18;
                    log.warn("Error while creating zipFile.And it's a ClientAbortException");
                }
            }
            try {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(zipFile));
                byte[] buffer = new byte[((InputStream)fis).available()];
                ((InputStream)fis).read(buffer);
                ((InputStream)fis).close();
                response.reset();
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment; filename=" + zipFile.getName());
                BufferedOutputStream output = new BufferedOutputStream((OutputStream)response.getOutputStream());
                ((OutputStream)output).write(buffer);
                ((OutputStream)output).flush();
                ((OutputStream)output).close();
                zipFile.delete();
            }
            catch (IOException e) {
                simplename = e.getClass().getSimpleName();
                if (!"ClientAbortException".equals(simplename)) break block19;
                log.warn("Error while transporting zipFile.And it's a ClientAbortException");
            }
        }
    }

    protected <A> Sheet createSheet(Workbook wb, String sheetName, List<A> datas, Excelable<A> exporter) {
        Sheet sheet = sheetName != null ? wb.createSheet(sheetName) : wb.createSheet();
        for (int i = 0; i < exporter.exportRowName().length; ++i) {
            sheet.setColumnWidth(i, 5120);
        }
        if (datas != null && !datas.isEmpty()) {
            List<ExcelCell[]> result = this.preprocessData(datas, exporter);
            int size = result.size();
            HashMap<ExcelCellStyle, CellStyle> styleMap = new HashMap<ExcelCellStyle, CellStyle>();
            for (int i = 0; i < size; ++i) {
                this.createRow(wb, sheet, i, result.get(i), styleMap);
            }
        }
        return sheet;
    }

    protected <A> List<ExcelCell[]> preprocessData(List<A> datas, Excelable<A> exporter) {
        ArrayList<ExcelCell[]> result = new ArrayList<ExcelCell[]>(datas.size() + 1);
        result.add(exporter.exportRowName());
        for (A data : datas) {
            result.add(exporter.exportRowValue(data));
        }
        return result;
    }

    protected Row createRow(Workbook wb, Sheet sheet, int rowNum, ExcelCell[] values, Map<ExcelCellStyle, CellStyle> styleMap) {
        Row row = sheet.createRow(rowNum);
        ExcelCell value = null;
        int size = values.length;
        Drawing p = sheet.createDrawingPatriarch();
        for (int i = 0; i < size; ++i) {
            ExcelCellStyle excelCellStyle;
            Cell cell = row.createCell(i);
            value = values[i];
            if (value == null) continue;
            cell.setCellValue(value.getValue().toString());
            if (!StringUtils.isBlank((String)value.getComment())) {
                cell.setCellComment(this.createCellComment(p, value, (short)i, rowNum));
            }
            if (value.getCellType() != null) {
                cell.setCellType(value.getCellType().intValue());
            }
            if ((excelCellStyle = value.getCellStyle()) == null) continue;
            CellStyle cellStyle = styleMap.get(excelCellStyle);
            if (cellStyle == null) {
                cellStyle = wb.createCellStyle();
                styleMap.put(excelCellStyle, cellStyle);
                Font font = null;
                if (excelCellStyle.getAlignment() != null) {
                    cellStyle.setAlignment(excelCellStyle.getAlignment().shortValue());
                }
                if (excelCellStyle.getVerticalAlignment() != null) {
                    cellStyle.setVerticalAlignment(excelCellStyle.getVerticalAlignment().shortValue());
                }
                if (excelCellStyle.getFontColor() != null) {
                    if (font == null) {
                        font = wb.createFont();
                    }
                    font.setColor(excelCellStyle.getFontColor().shortValue());
                }
                if (excelCellStyle.getBoldWeight() != null) {
                    if (font == null) {
                        font = wb.createFont();
                    }
                    font.setBoldweight(excelCellStyle.getBoldWeight().shortValue());
                }
                if (font != null) {
                    cellStyle.setFont(font);
                }
            }
            cell.setCellStyle(cellStyle);
        }
        return row;
    }

    protected Comment createCellComment(Drawing draw, ExcelCell value, short col, int row) {
        short col2 = col;
        int row2 = row;
        col2 = (short)(col2 + 1);
        ++row2;
        int len = 0;
        try {
            len = value.getComment().getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (len > 24) {
            col2 = (short)(col + 3);
            row2 = row + (len - 1) / 24 + 1;
        } else {
            col2 = (short)(col + (len + 2) / 9 + 1);
        }
        Comment comment = draw.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 127, col, row, col2, row2));
        comment.setString((RichTextString)new HSSFRichTextString(value.getComment()));
        comment.setVisible(value.isCommentVisible());
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet("ExportDataList");
        Row headerTitle = sheet.createRow(0);
        Cell cell = headerTitle.createCell(0);
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 127;
        short col = 0;
        int row = 0;
        short col2 = 1;
        int row2 = 1;
        String value = "123456789012345";
        int len = 0;
        try {
            len = value.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        System.out.println(len);
        if (len > 24) {
            col2 = (short)(col + 3);
            row2 = row + (len - 1) / 24 + 1;
        } else {
            col2 = (short)(col + (len + 2) / 9 + 1);
            dx2 = (len + 3) % 9 * 113;
        }
        cell.setCellValue(value);
        Drawing draw = sheet.createDrawingPatriarch();
        Comment comment = draw.createCellComment((ClientAnchor)new HSSFClientAnchor(dx1, dy1, dx2, dy2, col, row, col2, row2));
        comment.setString((RichTextString)new HSSFRichTextString(value));
        comment.setVisible(false);
        cell.setCellComment(comment);
        OutputStream os = null;
        try {
            os = new FileOutputStream("d:\\test" + System.currentTimeMillis() + ".xls");
            wb.write(os);
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                os = null;
            }
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                wb = null;
            }
        }
    }

    protected static Workbook getExcelWorkbook(String name, InputStream input) throws IOException, OpenXML4JException, POIXMLException {
        if (name.endsWith(".xls")) {
            return new HSSFWorkbook(input);
        }
        if (name.endsWith(".xlsx")) {
            return new XSSFWorkbook(input);
        }
        return null;
    }

    protected static <T> void procExcelWorkbook(Workbook workbook, CellProcess<T> process, T result) {
        Sheet sheet = null;
        Row row = null;
        Cell cell = null;
        int sheetSize = workbook.getNumberOfSheets();
        int rowSize = 0;
        short cellSize = 0;
        for (int numSheet = 0; numSheet < sheetSize; ++numSheet) {
            sheet = workbook.getSheetAt(numSheet);
            if (sheet == null) continue;
            rowSize = sheet.getLastRowNum();
            for (int rowNum = sheet.getFirstRowNum(); rowNum <= rowSize; ++rowNum) {
                row = sheet.getRow(rowNum);
                if (row == null) continue;
                cellSize = row.getLastCellNum();
                for (int cellNum = row.getFirstCellNum(); cellNum <= cellSize; ++cellNum) {
                    cell = row.getCell(cellNum);
                    if (cell == null) continue;
                    process.proc(cell, result);
                }
            }
        }
    }

    protected static String getExcelCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case 0: {
                return new BigDecimal(cell.getNumericCellValue()).toString();
            }
        }
        return String.valueOf(cell.getStringCellValue());
    }

    public static interface CellProcess<T> {
        public void proc(Cell var1, T var2);
    }
}

