/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dto;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ErrorCodeUtil;
import java.io.Serializable;

public class WebResponse<T>
implements Serializable {
    private static final long serialVersionUID = 218412192938273843L;
    private long code;
    private String msg;
    private T data;
    private PageDto pageDto;

    public WebResponse() {
        this.code = 0L;
    }

    public WebResponse(T data) {
        this.code = 0L;
        this.data = data;
    }

    public WebResponse(T data, PageDto pageDto) {
        this.code = 0L;
        this.data = data;
        if (null != pageDto) {
            pageDto.validate();
        }
        this.pageDto = pageDto;
    }

    public WebResponse(UniverseErrorCode errorCode) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = errorCode.getMessage();
    }

    public WebResponse(UniverseErrorCode errorCode, String msg) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = msg;
    }

    public void setErrorCode(UniverseErrorCode errorCode, String msg) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        this.msg = msg;
    }

    public void setErrorCode(UniverseErrorCode errorCode) {
        this.code = ErrorCodeUtil.getUniverseErrorCode(errorCode);
        if (errorCode != null) {
            this.msg = errorCode.getMessage();
        }
    }

    public long getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResponse)) {
            return false;
        }
        WebResponse other = (WebResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $code = this.getCode();
        result = result * 59 + (int)($code >>> 32 ^ $code);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public String toString() {
        return "WebResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", pageDto=" + this.getPageDto() + ")";
    }
}

