/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.beanCopy.defaultTypeConverter;

import com.baijia.tianxiao.beanCopy.Typeconverter;
import com.baijia.tianxiao.util.GenericsUtils;
import java.lang.reflect.Type;
import java.util.regex.Pattern;

public class Str2NumberConverter
extends Typeconverter {
    private static final String NUM_REGEX = "-?\\d+((\\.\\d+)?)";

    @Override
    public Object convert(String fieldName, Type sourceFieldType, Type destFieldType, Object value) {
        super.checkConvertTypes(sourceFieldType, destFieldType);
        Object setValue = value;
        if (value != null) {
            if (String.class == sourceFieldType && (destFieldType instanceof Number || ((Class)destFieldType).isPrimitive())) {
                String strValue = (String)value;
                boolean isNumStr = this.checkIsNumStr(strValue);
                if (!isNumStr) {
                    throw new IllegalArgumentException(String.format("%s not a digital string", value));
                }
                setValue = GenericsUtils.getNumValueFromStr((Class)destFieldType, strValue);
            } else if ((sourceFieldType instanceof Number || ((Class)sourceFieldType).isPrimitive()) && destFieldType == String.class) {
                setValue = value.toString();
            }
        }
        return setValue;
    }

    private boolean checkIsNumStr(String setValue) {
        return Pattern.compile(NUM_REGEX).matcher(setValue).matches();
    }

    public static void main(String[] args) {
    }
}

