/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.base;

import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.CustomException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.WebResponseHelper;
import com.baijia.tianxiao.util.date.TimeStampPropertyEditor;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.response.ResponseUtil;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class BaseController {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    private static final String LOG_SEPARATOR = " - ";
    private static final Class<?>[] CUSTOM_EXCEPTION = new Class[]{BussinessException.class, ParameterException.class, PermissionException.class, WebServiceException.class, WechatException.class};
    private static final String TIANXIAO_APP_FLAG = "tianxiao";

    @ExceptionHandler(value={Exception.class})
    public void exception(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        WechatException we;
        LogLevel logLevel;
        String uri = request.getRequestURI();
        String requestParams = this.getRequestParamStr(request);
        WebResponse webResponse = null;
        StringBuilder logStrBulider = new StringBuilder();
        Object[] logParams = null;
        String exceptionName = null;
        LinkedHashMap<String, Object> logParamsMap = new LinkedHashMap<String, Object>();
        String simpleName = exception.getClass().getSimpleName();
        if (exception instanceof CustomException) {
            CustomException baseException = (CustomException)exception;
            exceptionName = CustomException.class.getSimpleName();
            webResponse = WebResponseHelper.error(baseException.getErrorCode(), baseException.getMessage());
            for (Class<?> customException : CUSTOM_EXCEPTION) {
                if (exception.getClass() != customException) continue;
                exceptionName = customException.getSimpleName();
            }
            logParamsMap.put("requestParams", requestParams);
            logParamsMap.put("errorCode", baseException.getErrorCode());
            logParamsMap.put("msg", baseException.getMessage());
            logLevel = LogLevel.WARN;
        } else if (exception instanceof IllegalArgumentException || exception instanceof MissingServletRequestParameterException || exception instanceof MethodArgumentTypeMismatchException || simpleName.equals("ClientAbortException")) {
            webResponse = WebResponseHelper.error(CommonErrorCode.PARAM_ERROR, exception.getMessage());
            exceptionName = simpleName;
            logParamsMap.put("requestParams", requestParams);
            logLevel = LogLevel.WARN;
        } else {
            webResponse = WebResponseHelper.error(CommonErrorCode.SYSTEM_ERROR);
            exceptionName = Exception.class.getSimpleName();
            logParamsMap.put("requestParams", requestParams);
            logLevel = LogLevel.ERROR;
        }
        if (exception instanceof WechatException && (we = (WechatException)exception).getErrorCode().getSubsystemErrorCode() == SalWechatErrorCode.WECHAT_REFRESH_TOKEN_IS_INVALID.getSubsystemErrorCode()) {
            logLevel = LogLevel.WARN;
        }
        logStrBulider.append(exceptionName).append(LOG_SEPARATOR);
        logStrBulider.append(uri).append(LOG_SEPARATOR);
        if (logParamsMap != null && !logParamsMap.isEmpty()) {
            logParams = new Object[logParamsMap.size()];
            int i = 0;
            for (String key : logParamsMap.keySet()) {
                if (i != 0) {
                    logStrBulider.append(",");
                }
                logStrBulider.append(key).append(":{}");
                logParams[i] = logParamsMap.get(key);
                ++i;
            }
        }
        switch (logLevel) {
            case TRACE: {
                log.trace(logStrBulider.toString(), logParams);
                break;
            }
            case DEBUG: {
                log.debug(logStrBulider.toString(), logParams);
                break;
            }
            case INFO: {
                log.info(logStrBulider.toString(), logParams);
                break;
            }
            case WARN: {
                log.warn(logStrBulider.toString(), logParams);
                break;
            }
            case ERROR: {
                log.error(logStrBulider.toString(), logParams);
                log.error(exception.getMessage(), (Throwable)exception);
                break;
            }
            default: {
                exception.printStackTrace();
            }
        }
        try {
            response.setContentType("application/json;charset=UTF-8");
            JacksonUtil.writeObj((OutputStream)response.getOutputStream(), webResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getRequestParamStr(HttpServletRequest httpRequest) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        Map paramMap = httpRequest.getParameterMap();
        boolean flag = false;
        String[] values = null;
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                if (flag) {
                    builder.append(", ");
                } else {
                    flag = true;
                }
                values = (String[])paramMap.get(key);
                builder.append(key).append(":");
                builder.append("[");
                if (values != null && values.length > 0) {
                    for (int j = 0; j < values.length; ++j) {
                        builder.append(values[j]);
                        if (j == values.length - 1) continue;
                        builder.append(",");
                    }
                }
                builder.append("]");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    PageDto parsePageDto(String pageDtoJsonStr) {
        PageDto dto = new PageDto();
        if (StringUtils.isNotBlank((CharSequence)pageDtoJsonStr)) {
            JSONObject pageJson = JSONObject.fromObject((Object)pageDtoJsonStr);
            dto.setPageNum(Integer.valueOf(pageJson.optInt("pageNum", -1)));
            dto.setPageSize(Integer.valueOf(pageJson.optInt("pageSize", -1)));
        }
        return dto;
    }

    void printJson(HttpServletRequest req, HttpServletResponse resp, Object data) {
        resp.setContentType("application/json;charset=utf-8");
        ResponseUtil.write(resp, data);
    }

    public static String encodeToken(Long id) throws Exception {
        String token = EncryptUtils.encodeWithAES(id.toString());
        return token;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new TimeStampPropertyEditor());
    }

    public boolean isApp(HttpServletRequest request) {
        String userAgent = ((String)StringUtils.defaultIfBlank((CharSequence)request.getHeader("User-Agent"), (CharSequence)"")).toLowerCase();
        if (StringUtils.isEmpty((CharSequence)userAgent)) {
            return false;
        }
        return userAgent.contains(TIANXIAO_APP_FLAG);
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

