package com.baijia.tianxiao.util.page;

import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collections;
import java.util.List;

/**
 * @author cxm
 * @version 1.0
 * @title PageUtils
 * @desc TODO
 * @date 2016年5月13日
 */
public class PageUtils {
    /**
     * 内存分页，不包含任何校验信息
     *
     * @param list
     * @param page
     * @return
     */
    public static <T> List<T> getList(List<T> list, final PageDto page) {
        if (page == null) {
            return list;
        }

        page.setCount(list.size());
        List<T> subList = Lists.newArrayList();
        int offset = page.firstNum();
        int count = 0;
        for (int i = offset; i < list.size(); i++) {
            if (count < page.getPageSize()) {
                subList.add(list.get(i));
                count++;
            }
        }
        page.setCurPageCount(subList.size());
        return subList;
    }

    /**
     * 内存分页，包含页面数据校验
     *
     * @param list
     * @param pageDto
     * @return
     * @author fulinyu
     */
    public static <T> List<T> getListWithValidate(List<T> list, final PageDto pageDto) {
        if (pageDto == null) {
            return list;
        }
        if (CollectionUtils.isEmpty(list)) {
            pageDto.setCount(0);
            pageDto.setCurPageCount(0);
            return Collections.emptyList();
        }
        Integer count = list.size();
        Integer pageNum = (count - 1) / pageDto.getPageSize() + 1;// 总页数
        if (pageDto.getPageNum() > pageNum) {
            return Collections.emptyList();
        }
        Integer lastPageCount = count % pageDto.getPageSize() == 0 ? pageDto.getPageSize() : count % pageDto.getPageSize();// 最后一页的列表数目
        if (pageDto.getPageNum() < pageNum) {
            pageDto.setCurPageCount(pageDto.getPageSize());
        } else {
            pageDto.setCurPageCount(lastPageCount);
        }
        pageDto.setCount(count);
        List<T> result = Lists.newArrayList();
        int startNum = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        for (int i = startNum; i < startNum + pageDto.getCurPageCount(); i++) {
            result.add(list.get(i));
        }
        return result;
    }

}
