package com.baijia.tianxiao.util.encrypt;

import org.apache.commons.codec.binary.Base64;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/**
 * @title HMACUtils
 * @desc TODO
 * @author wangzhigang
 * @date 2014年12月3日
 * @version 1.0
 */
public final class HMACUtils {

    private static final String HMAC_SHA1 = "HmacSHA1";

    public static final String encrypt(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec hashKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(hashKey);
        byte[] hmacData = mac.doFinal(data);
        return Base64.encodeBase64String(hmacData);
    }
}
