package com.baijia.tianxiao.util.exception;

import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 31/07/2017 11:49 AM
 */
public class BussinessPreconditions {
    private BussinessPreconditions() {
    }

    public static void checkArgument(boolean expression) {
        checkArgument(expression, CommonErrorCode.BUSINESS_ERROR);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode) {
        if (!expression) {
            throw new BussinessException(errorCode);
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        checkArgument(expression, CommonErrorCode.BUSINESS_ERROR, errorMessage);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode, Object errorMessage) {
        if (!expression) {
            throw new BussinessException(errorCode, String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object...errorMessageArgs) {
        checkArgument(expression, CommonErrorCode.BUSINESS_ERROR, errorMessageTemplate, errorMessageArgs);
    }

    public static void checkArgument(boolean expression, CommonErrorCode errorCode, String errorMessageTemplate,
        Object...errorMessageArgs) {
        if (!expression) {
            throw new BussinessException(errorCode, format(errorMessageTemplate, errorMessageArgs));
        }
    }

    // Note that this is somewhat-improperly used from Verify.java as well.
    static String format(String template, Object...args) {
        template = String.valueOf(template); // null -> "null"

        // start substituting the arguments into the '%s' placeholders
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length) {
            int placeholderStart = template.indexOf("%s", templateStart);
            if (placeholderStart == -1) {
                break;
            }
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));

        // if we run out of placeholders, append the extra args in square braces
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }

        return builder.toString();
    }
}
