package com.baijia.tianxiao.util;

import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dto.RestfulResult;
import com.baijia.tianxiao.util.http.GSXService;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author cxm
 * @version 1.0
 * @title SmsSendUtil
 * @desc TODO
 * @date 2015年10月26日
 */
@Slf4j
public class SmsSendUtil {

    public static final String GSX_SMS_CONTROLLER = "sms";//跟谁学服务接口
    public static final String GSX_SMS_ACTION = "send";//跟谁学服务接口
    public static Integer DEFAULT_SMS_GATE = 6;//天校后缀短信发送默认网关6

    public static boolean sendTxSms(String mobile, String content, Integer userId, Integer userRole, Integer smsGate) {
        //封禁短信在yunying.tx_account.sms_gate=-1里配置
        if (smsGate != null && smsGate.intValue() == -1) {
            return false;
        }

        RestfulResult<Object> response = send(mobile, content, SmsMessageType.TIANXIAO_NOTIFY.getCode(), userId, userRole, true, smsGate);
        return response != null && response.getCode() == 0;
    }

    public static RestfulResult<Object> send(String mobile, String content, Integer messageType, Integer userId,
                                             Integer userRole, boolean directSend, Integer smsGate) {
        RestfulResult<Object> response = null;

        //封禁短信在yunying.tx_account.sms_gate=-1里配置
        if (smsGate != null && smsGate.intValue() == -1) {
            return RestfulResult.buildError("发送短信功能被禁用");
        }
        try {
            SortedMap<String, String> params = new TreeMap<String, String>();
            params.put("mobile", mobile.replaceAll(" ", "").replace("-", ""));
            Preconditions.checkArgument(ParamValidateUtils.validateMobile(params.get("mobile")),
                    "mobile :" + mobile + " is invalidate.");

            params.put("content", content);
            params.put("message_type", String.valueOf(messageType));
            if (userId != null) {
                params.put("user_id", String.valueOf(userId));
            }
            if (userRole != null) {
                params.put("role", String.valueOf(userRole));
            }
            if (directSend) {
                params.put("direct_send", "1");
            }
            if (smsGate != null) {
                params.put("gateway", smsGate.toString());
            } else {
                params.put("gateway", String.valueOf(DEFAULT_SMS_GATE));
            }

            log.info("send sms to mobile:{},params:{}", mobile, params);
            response = GSXService.doService(GSX_SMS_CONTROLLER, GSX_SMS_ACTION, params);
            log.info("params:{}, response:{}", params, response);
        } catch (Exception e) {
            response = RestfulResult.buildError("发送短信失败");
            log.error("sendSms exception - ", e);
        }
        return response;
    }

    public static void main(String[] args) {
        Integer userId = 489661;
        // System.out.println(smsList.contains(userId == null ? 0 : userId.intValue()));
    }

}
