
package com.baijia.tianxiao.filter;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;

public class TianxiaoPCContext extends AbstractTXWebContext {

    private static final String ORG_ID = "org_id";
    private static final String ORG_CASCADE_ID = "org_cascade_id";
    private static final String ORG_CASCADE_AUTH = "org_cascade_AUTH";
    private static final String ORG_APP_AUTH_TOKEN = "org_app_AUTH_token";
    private static final String TX_CASCADE_ID = "tx_cascade_id";
    private static final String TX_LOGIN_ACCOUNT_ID = "tx_login_account_id";

    @Override
    protected void init() {
        // nothing to do
    }

    /**
     * 解析App传入token为对象
     *
     * @return
     */
    public static AppAuthToken getAppAuthToken() {
        return get(ORG_APP_AUTH_TOKEN, AppAuthToken.class);
    }

    public static void setAppAuthToken(AppAuthToken obj) {
        set(ORG_APP_AUTH_TOKEN, obj);
    }

    /**
     * 机构id
     * 
     * @return
     */
    public static Integer getOrgId() {
        return get(ORG_ID, Integer.class);
    }

    public static Long getOrgIdLong() {
        Integer orgId = getOrgId();
        return null == orgId ? null : orgId.longValue();
    }

    public static void setOrgId(Integer orgId) {
        set(ORG_ID, orgId);
    }

    /**
     * 天校子帐号id
     * 
     * @return
     */
    public static Integer getTXCascadeId() {
        return get(TX_CASCADE_ID, Integer.class);
    }

    public static Long getTXCascadeIdLongZeroFill() {
        Integer obj = getTXCascadeId();
        if (obj != null) {
            return obj.longValue();
        }
        return 0L;
    }

    public static void setTXCascadeId(Integer cascadeId) {
        set(TX_CASCADE_ID, cascadeId);
    }

    /**
     * 天校帐号id，
     * 
     * @return
     */
    public static Integer getTXLoginAccountId() {
        return get(TX_LOGIN_ACCOUNT_ID, Integer.class);
    }

    public static void setTXLoginAccountId(Integer cascadeId) {
        set(TX_LOGIN_ACCOUNT_ID, cascadeId);
    }

    @Deprecated
    public static void setOrgCascadeId(Long orgCascadeId) {
        set(ORG_CASCADE_ID, orgCascadeId);
    }

    @Deprecated
    public static Long getOrgCascadeId() {
        return get(ORG_CASCADE_ID, Long.class);
    }

    @Deprecated
    public static void setOrgCascadeAuth(String orgCascadeAuth) {
        set(ORG_CASCADE_AUTH, orgCascadeAuth);
    }

    @Deprecated
    public static String getOrgCascadeAuth() {
        return get(ORG_CASCADE_AUTH, String.class);
    }
}
