/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dto.signup;


import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;

@Data
public class PayResultDto {

	@JsonProperty("id")
	private Long id;
	
	@JsonProperty("purchase_id")
	private Long purchaseId;
	
	@JsonProperty("org_id")
	private Long orgId;
	
	@JsonProperty("org_number")
	private Long orgNumber;
	
	@JsonProperty("status")
	private Integer status;  //0-交易中  1-交易完成  2-交易失败  3-交易取消
	
	@JsonProperty("total_prices")
	private double totalPrice;
	
	@JsonProperty("pay_money")
	private double payMoney;
	
	@JsonProperty("pay_type")
	private Map<String,String> payType;
	
	@JsonProperty("total_fee")
	private double totalFee;
	
	@JsonProperty("trade_no")
	private String tradeNo;
	
	@JsonProperty("pay_time")
	private String payTime;
	
	@JsonProperty("create_time")
	private String createTime;
	
	@JsonProperty("update_time")
	private String updateTime;
	
	@JsonProperty("org_name")
	private String orgName;
	
	@JsonProperty("ip")
	private String ip;
	
	@JsonProperty("note")
	private String note;
	
	@JsonProperty("channel_id")
	private String channelId;
	
	@JsonProperty("pay_type_str")
	private String payTypeStr;
	
	@JsonProperty("count")
	private Integer count;
	
	@JsonProperty("course_name")
	private String courseName;
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

